/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import java.util.Locale;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Tier;
import mekanism.common.block.BlockTransmitter;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.block.property.PropertyConnection;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStateTransmitter
extends ExtendedBlockState {
    public static final PropertyEnum<TransmitterType> typeProperty = PropertyEnum.func_177709_a((String)"type", TransmitterType.class);
    public static final PropertyEnum<Tier.BaseTier> tierProperty = PropertyEnum.func_177709_a((String)"tier", Tier.BaseTier.class);

    public BlockStateTransmitter(BlockTransmitter block) {
        super((Block)block, new IProperty[]{typeProperty, tierProperty}, new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE, PropertyColor.INSTANCE, PropertyConnection.INSTANCE});
    }

    public static class TransmitterStateMapper
    extends StateMapperBase {
        protected ModelResourceLocation func_178132_a(IBlockState state) {
            BlockTransmitter block = (BlockTransmitter)state.func_177230_c();
            TransmitterType type = (TransmitterType)((Object)state.func_177229_b(typeProperty));
            StringBuilder builder = new StringBuilder();
            String nameOverride = null;
            if (type.tiers) {
                Tier.BaseTier tier = (Tier.BaseTier)((Object)state.func_177229_b(tierProperty));
                if (tier == Tier.BaseTier.CREATIVE) {
                    tier = Tier.BaseTier.ULTIMATE;
                }
                nameOverride = type.func_176610_l() + "_" + tier.func_176610_l();
            }
            if (builder.length() == 0) {
                builder.append("normal");
            }
            ResourceLocation baseLocation = new ResourceLocation("mekanism", nameOverride != null ? nameOverride : type.func_176610_l());
            return new ModelResourceLocation(baseLocation, builder.toString());
        }
    }

    public static enum TransmitterType implements IStringSerializable
    {
        UNIVERSAL_CABLE("UniversalCable", Size.SMALL, TransmissionType.ENERGY, false, true),
        MECHANICAL_PIPE("MechanicalPipe", Size.LARGE, TransmissionType.FLUID, false, true),
        PRESSURIZED_TUBE("PressurizedTube", Size.SMALL, TransmissionType.GAS, false, true),
        LOGISTICAL_TRANSPORTER("LogisticalTransporter", Size.LARGE, TransmissionType.ITEM, true, true),
        RESTRICTIVE_TRANSPORTER("RestrictiveTransporter", Size.LARGE, TransmissionType.ITEM, false, false),
        DIVERSION_TRANSPORTER("DiversionTransporter", Size.LARGE, TransmissionType.ITEM, true, false),
        THERMODYNAMIC_CONDUCTOR("ThermodynamicConductor", Size.SMALL, TransmissionType.HEAT, false, true);

        private String unlocalizedName;
        private Size size;
        private TransmissionType transmissionType;
        private boolean transparencyRender;
        private boolean tiers;

        private TransmitterType(String name, Size s, TransmissionType type, boolean transparency, boolean b) {
            this.unlocalizedName = name;
            this.size = s;
            this.transmissionType = type;
            this.transparencyRender = transparency;
            this.tiers = b;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public Size getSize() {
            return this.size;
        }

        public boolean hasTransparency() {
            return this.transparencyRender;
        }

        public TransmissionType getTransmission() {
            return this.transmissionType;
        }

        public boolean hasTiers() {
            return this.tiers;
        }

        public static TransmitterType get(int meta) {
            return TransmitterType.values()[meta];
        }

        public static enum Size {
            SMALL(6),
            LARGE(8);

            public int centerSize;

            private Size(int size) {
                this.centerSize = size;
            }
        }
    }
}

