/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.base.ISustainedData;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.item.ItemStack;

public class InfuseStorage
implements ISustainedData {
    public InfuseType type;
    public int amount;

    public InfuseStorage() {
    }

    public InfuseStorage(InfuseType infuseType, int infuseAmount) {
        this.type = infuseType;
        this.amount = infuseAmount;
    }

    public boolean contains(InfuseStorage storage) {
        return this.type == storage.type && this.amount >= storage.amount;
    }

    public void subtract(InfuseStorage storage) {
        if (this.contains(storage)) {
            this.amount -= storage.amount;
        } else if (this.type == storage.type) {
            this.amount = 0;
        }
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.type != null && this.amount > 0) {
            ItemDataUtils.setString(itemStack, "infuseType", this.type.name);
            ItemDataUtils.setInt(itemStack, "infuseAmount", this.amount);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "infuseType") && ItemDataUtils.hasData(itemStack, "infuseAmount")) {
            this.type = InfuseRegistry.get(ItemDataUtils.getString(itemStack, "infuseType"));
            if (this.type != null) {
                this.amount = ItemDataUtils.getInt(itemStack, "infuseAmount");
            }
        } else {
            this.type = null;
            this.amount = 0;
        }
    }
}

