/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.voice;

import java.io.EOFException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import mekanism.client.voice.VoiceClient;
import mekanism.common.Mekanism;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VoiceOutput
extends Thread {
    public VoiceClient voiceClient;
    public DataLine.Info speaker;
    public SourceDataLine sourceLine;

    public VoiceOutput(VoiceClient client2) {
        this.voiceClient = client2;
        this.speaker = new DataLine.Info(SourceDataLine.class, this.voiceClient.format, 2200);
        this.setDaemon(true);
        this.setName("VoiceServer Client Output Thread");
    }

    @Override
    public void run() {
        try {
            this.sourceLine = (SourceDataLine)AudioSystem.getLine(this.speaker);
            this.sourceLine.open(this.voiceClient.format, 2200);
            this.sourceLine.start();
            byte[] audioData = new byte[4096];
            while (this.voiceClient.running) {
                try {
                    int length;
                    for (int byteCount = this.voiceClient.input.readUnsignedShort(); byteCount > 0 && this.voiceClient.running; byteCount -= length) {
                        length = audioData.length;
                        if (length > byteCount) {
                            length = byteCount;
                        }
                        if ((length = this.voiceClient.input.read(audioData, 0, length)) < 0) {
                            throw new EOFException();
                        }
                        this.sourceLine.write(audioData, 0, length);
                    }
                }
                catch (EOFException eof) {
                    Mekanism.logger.error("VoiceServer: Unexpected input EOF Exception occured.");
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while running client output thread.");
            e.printStackTrace();
        }
    }

    public void close() {
        this.sourceLine.flush();
        this.sourceLine.close();
    }
}

