/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class GuiEnergyGauge
extends GuiGauge {
    IEnergyInfoHandler infoHandler;

    public GuiEnergyGauge(IEnergyInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y);
        this.infoHandler = handler;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth - 26, guiHeight + 6, 26, 26);
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.ENERGY;
    }

    @Override
    public int getScaledLevel() {
        if (this.infoHandler.getEnergyStorage().getEnergy() == Double.MAX_VALUE) {
            return this.height - 2;
        }
        return (int)(this.infoHandler.getEnergyStorage().getEnergy() * (double)(this.height - 2) / this.infoHandler.getEnergyStorage().getMaxEnergy());
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return MekanismRenderer.energyIcon;
    }

    @Override
    public String getTooltipText() {
        return this.infoHandler.getEnergyStorage().getEnergy() > 0.0 ? MekanismUtils.getEnergyDisplay(this.infoHandler.getEnergyStorage().getEnergy(), this.infoHandler.getEnergyStorage().getMaxEnergy()) : LangUtils.localize("gui.empty");
    }

    public static interface IEnergyInfoHandler {
        public IStrictEnergyStorage getEnergyStorage();
    }
}

