/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.OreDictCache;
import mekanism.common.base.TileNetworkList;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.content.transporter.TMaterialFilter;
import mekanism.common.content.transporter.TModIDFilter;
import mekanism.common.content.transporter.TOreDictFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiLogisticalSorter
extends GuiMekanism {
    public TileEntityLogisticalSorter tileEntity;
    private boolean wasClicking;
    int BUTTON_NEW = 0;
    public float scroll;
    public boolean isDragging = false;
    private final int scrollX = 154;
    private final int scrollY = 18;
    private final int scrollW = 12;
    private final int scrollH = 138;
    private final int filterX = 56;
    private final int filterY = 18;
    private final int filterW = 96;
    private final int filterH = 29;
    public int dragOffset = 0;
    public int stackSwitch = 0;
    public Map<TOreDictFilter, StackData> oreDictStacks = new HashMap<TOreDictFilter, StackData>();
    public Map<TModIDFilter, StackData> modIDStacks = new HashMap<TModIDFilter, StackData>();

    public GuiLogisticalSorter(EntityPlayer player, TileEntityLogisticalSorter entity) {
        super(entity, new ContainerNull(player, entity));
        this.tileEntity = entity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiLogisticalSorter.png")));
        this.guiElements.add(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiLogisticalSorter.png")));
    }

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 123.0f), 123), 0);
    }

    public int getFilterIndex() {
        if (this.needsScrollBars()) {
            int scrollSize = this.tileEntity.filters.size() - 4;
            return (int)(((double)scrollSize + 0.5) * (double)this.scroll);
        }
        return 0;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0) {
            for (Map.Entry<TOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() <= 0) continue;
                if (entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size() - 1) {
                    entry.getValue().stackIndex = 0;
                } else if (entry.getValue().stackIndex < entry.getValue().iterStacks.size() - 1) {
                    ++entry.getValue().stackIndex;
                }
                entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
            }
            for (Map.Entry<TransporterFilter, StackData> entry : this.modIDStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() <= 0) continue;
                if (entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size() - 1) {
                    entry.getValue().stackIndex = 0;
                } else if (entry.getValue().stackIndex < entry.getValue().iterStacks.size() - 1) {
                    ++entry.getValue().stackIndex;
                }
                entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
            }
            this.stackSwitch = 20;
        } else {
            for (Map.Entry<TOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() != 0) continue;
                entry.getValue().renderStack = ItemStack.field_190927_a;
            }
            for (Map.Entry<TransporterFilter, StackData> entry : this.modIDStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() != 0) continue;
                entry.getValue().renderStack = ItemStack.field_190927_a;
            }
        }
        HashSet<TOreDictFilter> oreDictFilters = new HashSet<TOreDictFilter>();
        HashSet<TModIDFilter> hashSet = new HashSet<TModIDFilter>();
        for (int i = 0; i < 4; ++i) {
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) instanceof TOreDictFilter) {
                oreDictFilters.add((TOreDictFilter)this.tileEntity.filters.get(this.getFilterIndex() + i));
                continue;
            }
            if (!(this.tileEntity.filters.get(this.getFilterIndex() + i) instanceof TModIDFilter)) continue;
            hashSet.add((TModIDFilter)this.tileEntity.filters.get(this.getFilterIndex() + i));
        }
        for (TransporterFilter filter : this.tileEntity.filters) {
            if (filter instanceof TOreDictFilter && !oreDictFilters.contains(filter)) {
                if (!this.oreDictStacks.containsKey(filter)) continue;
                this.oreDictStacks.remove(filter);
                continue;
            }
            if (!(filter instanceof TModIDFilter) || hashSet.contains(filter) || !this.modIDStacks.containsKey(filter)) continue;
            this.modIDStacks.remove(filter);
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseBtn) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (mouseBtn == 0) {
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                if (this.needsScrollBars()) {
                    this.dragOffset = yAxis - (this.getScroll() + 18);
                    this.isDragging = true;
                } else {
                    this.scroll = 0.0f;
                }
            }
            for (int i = 0; i < 4; ++i) {
                TileNetworkList data;
                if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
                int yStart = i * 29 + 18;
                if (xAxis < 56 || xAxis > 152 || yAxis < yStart || yAxis > yStart + 29) continue;
                int arrowX = 140;
                if (this.getFilterIndex() + i > 0 && xAxis >= 140 && xAxis <= 150 && yAxis >= yStart + 14 && yAxis <= yStart + 20) {
                    data = TileNetworkList.withContents(3, this.getFilterIndex() + i);
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                    SoundHandler.playSound(SoundEvents.field_187909_gi);
                    return;
                }
                if (this.getFilterIndex() + i < this.tileEntity.filters.size() - 1 && xAxis >= 140 && xAxis <= 150 && yAxis >= yStart + 21 && yAxis <= yStart + 27) {
                    data = TileNetworkList.withContents(4, this.getFilterIndex() + i);
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                    SoundHandler.playSound(SoundEvents.field_187909_gi);
                    return;
                }
                TransporterFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
                if (filter instanceof TItemStackFilter) {
                    SoundHandler.playSound(SoundEvents.field_187909_gi);
                    Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 1, this.getFilterIndex() + i, 0));
                    continue;
                }
                if (filter instanceof TOreDictFilter) {
                    SoundHandler.playSound(SoundEvents.field_187909_gi);
                    Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 2, this.getFilterIndex() + i, 0));
                    continue;
                }
                if (filter instanceof TMaterialFilter) {
                    SoundHandler.playSound(SoundEvents.field_187909_gi);
                    Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 3, this.getFilterIndex() + i, 0));
                    continue;
                }
                if (!(filter instanceof TModIDFilter)) continue;
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 5, this.getFilterIndex() + i, 0));
            }
            if (xAxis >= 12 && xAxis <= 26 && yAxis >= 110 && yAxis <= 124) {
                TileNetworkList data = TileNetworkList.withContents(1);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
            if (xAxis >= 12 && xAxis <= 26 && yAxis >= 84 && yAxis <= 98) {
                TileNetworkList data = TileNetworkList.withContents(2);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
        }
        if (Keyboard.isKeyDown((int)42) && mouseBtn == 0) {
            mouseBtn = 2;
        }
        if (xAxis >= 13 && xAxis <= 29 && yAxis >= 137 && yAxis <= 153) {
            TileNetworkList data = TileNetworkList.withContents(0, mouseBtn);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            SoundHandler.playSound(MekanismSounds.DING);
        }
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (this.isDragging) {
            this.scroll = Math.min(Math.max((float)(yAxis - 18 - this.dragOffset) / 123.0f, 0.0f), 1.0f);
        }
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int type) {
        super.func_146286_b(mouseX, mouseY, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.tileEntity.filters.size() - 4;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.scroll = (float)((double)this.scroll - (double)i / (double)j);
            if (this.scroll < 0.0f) {
                this.scroll = 0.0f;
            }
            if (this.scroll > 1.0f) {
                this.scroll = 1.0f;
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(this.BUTTON_NEW, this.field_147003_i + 56, this.field_147009_r + 136, 96, 20, LangUtils.localize("gui.newFilter")));
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.BUTTON_NEW) {
            Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), 4, 0, 0));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.filters") + ":", 11, 19, 52480);
        this.field_146289_q.func_78276_b("T: " + this.tileEntity.filters.size(), 11, 28, 52480);
        this.field_146289_q.func_78276_b("RR:", 12, 74, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui." + (this.tileEntity.roundRobin ? "on" : "off")), 27, 86, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.logisticalSorter.auto") + ":", 12, 100, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui." + (this.tileEntity.autoEject ? "on" : "off")), 27, 112, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.logisticalSorter.default") + ":", 12, 126, 52480);
        for (int i = 0; i < 4; ++i) {
            ItemStack renderStack;
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            TransporterFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            if (filter instanceof TItemStackFilter) {
                TItemStackFilter itemFilter = (TItemStackFilter)filter;
                if (!itemFilter.itemType.func_190926_b()) {
                    GlStateManager.func_179094_E();
                    RenderHelper.func_74520_c();
                    this.field_146296_j.func_180450_b(itemFilter.itemType, 59, yStart + 3);
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179121_F();
                }
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getColoredName() : LangUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
            } else if (filter instanceof TOreDictFilter) {
                TOreDictFilter oreFilter = (TOreDictFilter)filter;
                if (!this.oreDictStacks.containsKey(oreFilter)) {
                    this.updateStackList(oreFilter);
                }
                if (!(renderStack = this.oreDictStacks.get((Object)filter).renderStack).func_190926_b()) {
                    try {
                        GlStateManager.func_179094_E();
                        RenderHelper.func_74520_c();
                        this.field_146296_j.func_180450_b(renderStack, 59, yStart + 3);
                        RenderHelper.func_74518_a();
                        GlStateManager.func_179121_F();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.oredictFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getColoredName() : LangUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
            } else if (filter instanceof TMaterialFilter) {
                TMaterialFilter itemFilter = (TMaterialFilter)filter;
                if (!itemFilter.materialItem.func_190926_b()) {
                    GlStateManager.func_179094_E();
                    RenderHelper.func_74520_c();
                    this.field_146296_j.func_180450_b(itemFilter.materialItem, 59, yStart + 3);
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179121_F();
                }
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.materialFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getColoredName() : LangUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
            } else if (filter instanceof TModIDFilter) {
                TModIDFilter modFilter = (TModIDFilter)filter;
                if (!this.modIDStacks.containsKey(modFilter)) {
                    this.updateStackList(modFilter);
                }
                if (!(renderStack = this.modIDStacks.get((Object)filter).renderStack).func_190926_b()) {
                    try {
                        GlStateManager.func_179094_E();
                        RenderHelper.func_74520_c();
                        this.field_146296_j.func_180450_b(renderStack, 59, yStart + 3);
                        RenderHelper.func_74518_a();
                        GlStateManager.func_179121_F();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.modIDFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getColoredName() : LangUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
            }
            int arrowX = 140;
            if (this.getFilterIndex() + i > 0 && xAxis >= 140 && xAxis <= 150 && yAxis >= yStart + 14 && yAxis <= yStart + 20) {
                this.func_146279_a(LangUtils.localize("gui.moveUp"), xAxis, yAxis);
            }
            if (this.getFilterIndex() + i >= this.tileEntity.filters.size() - 1 || xAxis < 140 || xAxis > 150 || yAxis < yStart + 21 || yAxis > yStart + 27) continue;
            this.func_146279_a(LangUtils.localize("gui.moveDown"), xAxis, yAxis);
        }
        if (this.tileEntity.color != null) {
            GlStateManager.func_179094_E();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            this.field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
            this.drawTexturedRectFromIcon(13, 137, MekanismRenderer.getColorIcon(this.tileEntity.color), 16, 16);
            GL11.glDisable((int)2896);
            GlStateManager.func_179121_F();
        }
        if (xAxis >= 13 && xAxis <= 29 && yAxis >= 137 && yAxis <= 153) {
            if (this.tileEntity.color != null) {
                this.func_146279_a(this.tileEntity.color.getColoredName(), xAxis, yAxis);
            } else {
                this.func_146279_a(LangUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 110 && yAxis <= 124) {
            this.func_146279_a(LangUtils.localize("gui.autoEject"), xAxis, yAxis);
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 84 && yAxis <= 98) {
            this.func_146279_a(LangUtils.localize("gui.logisticalSorter.roundRobin"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiLogisticalSorter.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.field_147003_i + 154, this.field_147009_r + 18 + this.getScroll(), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        for (int i = 0; i < 4; ++i) {
            boolean mouseOver;
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            TransporterFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            boolean bl = mouseOver = xAxis >= 56 && xAxis <= 152 && yAxis >= yStart && yAxis <= yStart + 29;
            if (filter instanceof TItemStackFilter) {
                MekanismRenderer.color(EnumColor.INDIGO, 1.0f, 2.5f);
            } else if (filter instanceof TOreDictFilter) {
                MekanismRenderer.color(EnumColor.BRIGHT_GREEN, 1.0f, 2.5f);
            } else if (filter instanceof TMaterialFilter) {
                MekanismRenderer.color(EnumColor.PURPLE, 1.0f, 4.0f);
            } else if (filter instanceof TModIDFilter) {
                MekanismRenderer.color(EnumColor.PINK, 1.0f, 2.5f);
            }
            this.func_73729_b(this.field_147003_i + 56, this.field_147009_r + yStart, mouseOver ? 0 : 96, 166, 96, 29);
            MekanismRenderer.resetColor();
            int arrowX = 140;
            if (this.getFilterIndex() + i > 0) {
                mouseOver = xAxis >= 140 && xAxis <= 150 && yAxis >= yStart + 14 && yAxis <= yStart + 20;
                this.func_73729_b(this.field_147003_i + 140, this.field_147009_r + yStart + 14, 190, mouseOver ? 143 : 115, 11, 7);
            }
            if (this.getFilterIndex() + i >= this.tileEntity.filters.size() - 1) continue;
            mouseOver = xAxis >= 140 && xAxis <= 150 && yAxis >= yStart + 21 && yAxis <= yStart + 27;
            this.func_73729_b(this.field_147003_i + 140, this.field_147009_r + yStart + 21, 190, mouseOver ? 157 : 129, 11, 7);
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 110 && yAxis <= 124) {
            this.func_73729_b(this.field_147003_i + 12, this.field_147009_r + 110, 176, 0, 14, 14);
        } else {
            this.func_73729_b(this.field_147003_i + 12, this.field_147009_r + 110, 176, 14, 14, 14);
        }
        if (xAxis >= 12 && xAxis <= 26 && yAxis >= 84 && yAxis <= 98) {
            this.func_73729_b(this.field_147003_i + 12, this.field_147009_r + 84, 190, 0, 14, 14);
        } else {
            this.func_73729_b(this.field_147003_i + 12, this.field_147009_r + 84, 190, 14, 14, 14);
        }
    }

    private void updateStackList(TOreDictFilter filter) {
        if (!this.oreDictStacks.containsKey(filter)) {
            this.oreDictStacks.put(filter, new StackData());
        }
        this.oreDictStacks.get((Object)filter).iterStacks = OreDictCache.getOreDictStacks(filter.oreDictName, false);
        this.stackSwitch = 0;
        this.func_73876_c();
        this.oreDictStacks.get((Object)filter).stackIndex = -1;
    }

    private void updateStackList(TModIDFilter filter) {
        if (!this.modIDStacks.containsKey(filter)) {
            this.modIDStacks.put(filter, new StackData());
        }
        this.modIDStacks.get((Object)filter).iterStacks = OreDictCache.getModIDStacks(filter.modID, false);
        this.stackSwitch = 0;
        this.func_73876_c();
        this.modIDStacks.get((Object)filter).stackIndex = -1;
    }

    private boolean needsScrollBars() {
        return this.tileEntity.filters.size() > 4;
    }

    public static class StackData {
        public List<ItemStack> iterStacks;
        public int stackIndex;
        public ItemStack renderStack = ItemStack.field_190927_a;
    }
}

