/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiFluidGauge;
import mekanism.client.gui.element.GuiGasGauge;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.TileNetworkList;
import mekanism.common.inventory.container.ContainerElectrolyticSeparator;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiElectrolyticSeparator
extends GuiMekanism {
    public TileEntityElectrolyticSeparator tileEntity;

    public GuiElectrolyticSeparator(InventoryPlayer inventory, TileEntityElectrolyticSeparator tentity) {
        super(tentity, new ContainerElectrolyticSeparator(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png")));
        this.guiElements.add(new GuiUpgradeTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png")));
        this.guiElements.add(new GuiEnergyInfo(() -> {
            String usage2 = MekanismUtils.getEnergyDisplay(this.tileEntity.clientEnergyUsed);
            return ListUtils.asList(LangUtils.localize("gui.using") + ": " + usage2 + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.getMaxEnergy() - this.tileEntity.getEnergy()));
        }, (IGuiWrapper)this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png")));
        this.guiElements.add(new GuiFluidGauge(() -> this.tileEntity.fluidTank, GuiGauge.Type.STANDARD, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 5, 10));
        this.guiElements.add(new GuiGasGauge(() -> this.tileEntity.leftTank, GuiGauge.Type.SMALL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 58, 18));
        this.guiElements.add(new GuiGasGauge(() -> this.tileEntity.rightTank, GuiGauge.Type.SMALL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 100, 18));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 164, 15));
        this.guiElements.add(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png")));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 25, 34));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 58, 51));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 100, 51));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.NORMAL, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return GuiElectrolyticSeparator.this.tileEntity.isActive ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.BI, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"), 78, 29));
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        int xAxis = x - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = y - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis > 8 && xAxis < 17 && yAxis > 73 && yAxis < 82) {
            TileNetworkList data = TileNetworkList.withContents((byte)0);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        } else if (xAxis > 160 && xAxis < 169 && yAxis > 73 && yAxis < 82) {
            TileNetworkList data = TileNetworkList.withContents((byte)1);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), 45, 6, 0x404040);
        String name = this.chooseByMode(this.tileEntity.dumpLeft, LangUtils.localize("gui.idle"), LangUtils.localize("gui.dumping"), LangUtils.localize("gui.dumping_excess"));
        this.renderScaledText(name, 21, 73, 0x404040, 66);
        name = this.chooseByMode(this.tileEntity.dumpRight, LangUtils.localize("gui.idle"), LangUtils.localize("gui.dumping"), LangUtils.localize("gui.dumping_excess"));
        this.renderScaledText(name, 156 - (int)((float)this.field_146289_q.func_78256_a(name) * this.getNeededScale(name, 66)), 73, 0x404040, 66);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int displayInt = this.chooseByMode(this.tileEntity.dumpLeft, 52, 60, 68);
        this.func_73729_b(guiWidth + 8, guiHeight + 73, 176, displayInt, 8, 8);
        displayInt = this.chooseByMode(this.tileEntity.dumpRight, 52, 60, 68);
        this.func_73729_b(guiWidth + 160, guiHeight + 73, 176, displayInt, 8, 8);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    private <T> T chooseByMode(TileEntityGasTank.GasMode dumping, T idleOption, T dumpingOption, T dumpingExcessOption) {
        if (dumping.equals((Object)TileEntityGasTank.GasMode.IDLE)) {
            return idleOption;
        }
        if (dumping.equals((Object)TileEntityGasTank.GasMode.DUMPING)) {
            return dumpingOption;
        }
        if (dumping.equals((Object)TileEntityGasTank.GasMode.DUMPING_EXCESS)) {
            return dumpingExcessOption;
        }
        return idleOption;
    }
}

