/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.MekanismSounds;
import mekanism.common.config.MekanismConfig;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SparkleAnimation {
    public TileEntity pointer;
    public Random random = new Random();
    public Set<Coord4D> iteratedNodes = new HashSet<Coord4D>();
    public INodeChecker nodeChecker;

    public SparkleAnimation(TileEntity tileEntity, INodeChecker checker) {
        this.pointer = tileEntity;
        this.nodeChecker = checker;
    }

    public void run() {
        try {
            if (MekanismConfig.general.dynamicTankEasterEgg) {
                this.pointer.func_145831_w().func_184148_a(null, (double)this.pointer.func_174877_v().func_177958_n(), (double)this.pointer.func_174877_v().func_177956_o(), (double)this.pointer.func_174877_v().func_177952_p(), MekanismSounds.CJ_EASTER_EGG, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.loop(this.pointer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new Thread(() -> {
                World world = this.pointer.func_145831_w();
                for (Coord4D coord : this.iteratedNodes) {
                    for (int i = 0; i < 6; ++i) {
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.x + this.random.nextDouble(), (double)coord.y + -0.01, (double)coord.z + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.x + this.random.nextDouble(), (double)coord.y + 1.01, (double)coord.z + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.x + this.random.nextDouble(), (double)coord.y + this.random.nextDouble(), (double)coord.z + -0.01, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.x + this.random.nextDouble(), (double)coord.y + this.random.nextDouble(), (double)coord.z + 1.01, 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.x + -0.01, (double)coord.y + this.random.nextDouble(), (double)coord.z + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)coord.x + 1.01, (double)coord.y + this.random.nextDouble(), (double)coord.z + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loop(TileEntity tileEntity) {
        this.iteratedNodes.add(Coord4D.get(tileEntity));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity tile;
            Coord4D coord = Coord4D.get(tileEntity).offset(side);
            if (!coord.exists(this.pointer.func_145831_w()) || (tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w())) == null || !this.isNode(tile) || this.iteratedNodes.contains(coord)) continue;
            this.loop(tile);
        }
    }

    public boolean isNode(TileEntity tile) {
        return this.nodeChecker.isNode(tile);
    }

    public static interface INodeChecker {
        public boolean isNode(TileEntity var1);
    }
}

