/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GasTank
implements GasTankInfo {
    public GasStack stored;
    private int maxGas;

    private GasTank() {
    }

    public GasTank(int max) {
        this.maxGas = max;
    }

    public void setGas(GasStack stack) {
        this.stored = stack;
        if (this.stored != null) {
            this.stored.amount = Math.min(this.getMaxGas(), this.stored.amount);
        }
    }

    public GasStack draw(int amount, boolean doDraw) {
        if (this.stored == null || amount <= 0) {
            return null;
        }
        GasStack ret = new GasStack(this.getGas().getGas(), Math.min(this.getStored(), amount));
        if (ret.amount > 0) {
            if (doDraw) {
                this.stored.amount -= ret.amount;
                if (this.stored.amount <= 0) {
                    this.stored = null;
                }
            }
            return ret;
        }
        return null;
    }

    public int receive(GasStack amount, boolean doReceive) {
        if (amount == null || this.stored != null && (this.stored.amount == this.getMaxGas() || !this.stored.isGasEqual(amount))) {
            return 0;
        }
        int toFill = Math.min(this.getMaxGas() - this.getStored(), amount.amount);
        if (doReceive) {
            if (this.stored == null) {
                this.stored = amount.copy().withAmount(this.getStored() + toFill);
            } else {
                this.stored.amount = Math.min(this.getMaxGas(), this.getStored() + amount.amount);
            }
        }
        return toFill;
    }

    public boolean canReceive(Gas gas) {
        return this.getNeeded() != 0 && (this.stored == null || gas == null || gas == this.stored.getGas());
    }

    public boolean canReceiveType(Gas gas) {
        return this.stored == null || gas == null || gas == this.stored.getGas();
    }

    public boolean canDraw(Gas gas) {
        return this.stored != null && (gas == null || gas == this.stored.getGas());
    }

    public int getNeeded() {
        return this.getMaxGas() - this.getStored();
    }

    @Override
    public int getMaxGas() {
        return this.maxGas;
    }

    public void setMaxGas(int capacity) {
        this.maxGas = capacity;
    }

    @Override
    public GasStack getGas() {
        return this.stored;
    }

    public Gas getGasType() {
        return this.stored != null ? this.stored.getGas() : null;
    }

    @Override
    public int getStored() {
        return this.stored != null ? this.stored.amount : 0;
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        if (this.stored != null && this.stored.getGas() != null) {
            nbtTags.func_74782_a("stored", (NBTBase)this.stored.write(new NBTTagCompound()));
        }
        nbtTags.func_74768_a("maxGas", this.maxGas);
        return nbtTags;
    }

    public void read(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("stored")) {
            this.stored = GasStack.readFromNBT(nbtTags.func_74775_l("stored"));
        }
        if (nbtTags.func_74764_b("maxGas") && nbtTags.func_74762_e("maxGas") != 0) {
            this.maxGas = nbtTags.func_74762_e("maxGas");
        }
    }

    public static GasTank readFromNBT(NBTTagCompound nbtTags) {
        if (nbtTags == null || nbtTags.func_82582_d()) {
            return null;
        }
        GasTank tank = new GasTank();
        tank.read(nbtTags);
        return tank;
    }
}

