/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.handler;

import javax.annotation.Nullable;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageTeleportToWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class HandlerTeleportToWaystone
implements IMessageHandler<MessageTeleportToWaystone, IMessage> {
    @Nullable
    public IMessage onMessage(MessageTeleportToWaystone message, MessageContext ctx) {
        NetworkHandler.getThreadListener(ctx).func_152344_a(() -> {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            int dist = (int)Math.sqrt(player.func_174831_c(message.getWaystone().getPos()));
            int xpLevelCost = WaystoneConfig.general.blocksPerXPLevel > 0 ? MathHelper.func_76125_a((int)(dist / WaystoneConfig.general.blocksPerXPLevel), (int)0, (int)WaystoneConfig.general.maximumXpCost) : 0;
            ItemStack heldItem = player.func_184586_b(message.getHand());
            switch (message.getWarpMode()) {
                case INVENTORY_BUTTON: {
                    if (!(WaystoneConfig.general.teleportButtonReturnOnly || WaystoneConfig.general.inventoryButtonXpCost && player.field_71068_ca >= xpLevelCost)) {
                        return;
                    }
                    if (WaystoneConfig.general.teleportButton && !WaystoneConfig.general.teleportButtonReturnOnly && PlayerWaystoneHelper.canFreeWarp((EntityPlayer)ctx.getServerHandler().field_147369_b)) break;
                    return;
                }
                case WARP_SCROLL: {
                    if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Waystones.itemWarpScroll) break;
                    return;
                }
                case WARP_STONE: {
                    if (WaystoneConfig.general.warpStoneXpCost && player.field_71068_ca < xpLevelCost) {
                        return;
                    }
                    if (heldItem.func_190926_b() || heldItem.func_77973_b() != Waystones.itemWarpStone) {
                        return;
                    }
                    if (PlayerWaystoneHelper.canUseWarpStone((EntityPlayer)player)) break;
                    return;
                }
                case WAYSTONE: {
                    if (WaystoneConfig.general.waystoneXpCost && player.field_71068_ca < xpLevelCost) {
                        return;
                    }
                    WaystoneEntry fromWaystone = message.getFromWaystone();
                    if (fromWaystone != null && WaystoneManager.getWaystoneInWorld(fromWaystone) != null) break;
                    return;
                }
            }
            if (WaystoneManager.teleportToWaystone((EntityPlayer)ctx.getServerHandler().field_147369_b, message.getWaystone())) {
                boolean shouldCooldown = !message.getWaystone().isGlobal() || !WaystoneConfig.general.globalNoCooldown;
                switch (message.getWarpMode()) {
                    case INVENTORY_BUTTON: {
                        if (shouldCooldown) {
                            PlayerWaystoneHelper.setLastFreeWarp((EntityPlayer)ctx.getServerHandler().field_147369_b, System.currentTimeMillis());
                        }
                        if (!WaystoneConfig.general.inventoryButtonXpCost) break;
                        player.func_82242_a(-xpLevelCost);
                        break;
                    }
                    case WARP_SCROLL: {
                        heldItem.func_190918_g(1);
                        break;
                    }
                    case WARP_STONE: {
                        if (WaystoneConfig.general.warpStoneXpCost) {
                            player.func_82242_a(-xpLevelCost);
                        }
                        if (!shouldCooldown) break;
                        PlayerWaystoneHelper.setLastWarpStoneUse((EntityPlayer)ctx.getServerHandler().field_147369_b, System.currentTimeMillis());
                        break;
                    }
                    case WAYSTONE: {
                        if (!WaystoneConfig.general.waystoneXpCost) break;
                        player.func_82242_a(-xpLevelCost);
                    }
                }
            }
            WaystoneManager.sendPlayerWaystones((EntityPlayer)ctx.getServerHandler().field_147369_b);
        });
        return null;
    }
}

