/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.item.IResetUseOnDamage;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWarpScroll
extends Item
implements IResetUseOnDamage {
    private static final String NBT_WARP_SCROLL_TARGET = "WarpScrollTarget";
    public static final String name = "warp_scroll";
    public static final ResourceLocation registryName = new ResourceLocation("waystones", "warp_scroll");

    public ItemWarpScroll() {
        this.func_77637_a(Waystones.creativeTab);
        this.setRegistryName(name);
        this.func_77655_b(registryName.toString());
    }

    public int func_77626_a(ItemStack itemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        if (Waystones.proxy.isVivecraftInstalled()) {
            return EnumAction.NONE;
        }
        return EnumAction.BOW;
    }

    public String func_77667_c(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b(NBT_WARP_SCROLL_TARGET, 9)) {
            return "item.waystones:warp_scroll_bound";
        }
        return super.func_77667_c(stack);
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityLivingBase entityLiving) {
        NBTTagCompound compound = itemStack.func_77978_p();
        if (compound != null && compound.func_150297_b(NBT_WARP_SCROLL_TARGET, 9)) {
            if (!world.field_72995_K && entityLiving instanceof EntityPlayer) {
                NBTTagList tagList = compound.func_150295_c(NBT_WARP_SCROLL_TARGET, 3);
                int x = tagList.func_74745_c() > 0 ? ((NBTTagInt)tagList.func_179238_g(0)).func_150287_d() : (int)entityLiving.field_70165_t;
                int y = tagList.func_74745_c() > 1 ? ((NBTTagInt)tagList.func_179238_g(1)).func_150287_d() : (int)entityLiving.field_70163_u;
                int z = tagList.func_74745_c() > 2 ? ((NBTTagInt)tagList.func_179238_g(2)).func_150287_d() : (int)entityLiving.field_70161_v;
                int dimension = tagList.func_74745_c() > 3 ? ((NBTTagInt)tagList.func_179238_g(3)).func_150287_d() : entityLiving.func_130014_f_().field_73011_w.getDimension();
                WaystoneManager.teleportToPosition((EntityPlayer)entityLiving, world, new BlockPos(x, y, z), entityLiving.func_174811_aO(), dimension);
                if (!((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
            }
        } else if (world.field_72995_K) {
            Waystones.proxy.openWaystoneSelection(WarpMode.WARP_SCROLL, entityLiving.func_184600_cs(), null);
        }
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_184587_cr() && world.field_72995_K) {
            Waystones.proxy.playSound(SoundEvents.field_187814_ei, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), 2.0f);
        }
        if (Waystones.proxy.isVivecraftInstalled()) {
            this.func_77654_b(itemStack, world, (EntityLivingBase)player);
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return true;
    }
}

