/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.CommonProxy;
import net.blay09.mods.waystones.PlayerWaystoneData;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.client.gui.GuiButtonInventoryWarp;
import net.blay09.mods.waystones.client.gui.GuiConfirmInventoryButtonReturn;
import net.blay09.mods.waystones.client.gui.GuiEditWaystone;
import net.blay09.mods.waystones.client.gui.GuiWaystoneList;
import net.blay09.mods.waystones.client.render.RenderWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private GuiButtonInventoryWarp buttonWarp;
    private boolean isVivecraftInstalled;
    private static final List<String> tmpTooltip = Lists.newArrayList();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.bindTileEntitySpecialRenderer(TileWaystone.class, (TileEntitySpecialRenderer)new RenderWaystone());
        this.isVivecraftInstalled = ClientBrandRetriever.getClientModName().toLowerCase(Locale.ENGLISH).contains("vivecraft");
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (WaystoneConfig.general.teleportButton && event.getGui() instanceof GuiInventory) {
            this.buttonWarp = new GuiButtonInventoryWarp((GuiContainer)event.getGui());
            event.getButtonList().add(this.buttonWarp);
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() instanceof GuiButtonInventoryWarp) {
            EntityPlayerSP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (PlayerWaystoneHelper.canFreeWarp((EntityPlayer)entityPlayer)) {
                if (WaystoneConfig.general.teleportButtonReturnOnly) {
                    if (PlayerWaystoneHelper.getLastWaystone((EntityPlayer)entityPlayer) != null) {
                        event.getGui().field_146297_k.func_147108_a((GuiScreen)new GuiConfirmInventoryButtonReturn());
                    }
                } else {
                    Waystones.proxy.openWaystoneSelection(WarpMode.INVENTORY_BUTTON, EnumHand.MAIN_HAND, null);
                }
            } else {
                event.getGui().field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.5f));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiInventory && this.buttonWarp != null && this.buttonWarp.isHovered()) {
            tmpTooltip.clear();
            long timeSince = System.currentTimeMillis() - PlayerWaystoneHelper.getLastFreeWarp((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
            int secondsLeft = (int)(((long)(WaystoneConfig.general.teleportButtonCooldown * 1000) - timeSince) / 1000L);
            if (WaystoneConfig.general.teleportButtonReturnOnly) {
                tmpTooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.waystones:returnToWaystone", (Object[])new Object[0]));
                WaystoneEntry lastEntry = PlayerWaystoneHelper.getLastWaystone((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
                if (lastEntry != null) {
                    tmpTooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:boundTo", (Object[])new Object[]{TextFormatting.DARK_AQUA + lastEntry.getName()}));
                } else {
                    tmpTooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:boundTo", (Object[])new Object[]{I18n.func_135052_a((String)"tooltip.waystones:none", (Object[])new Object[0])}));
                }
                if (secondsLeft > 0) {
                    tmpTooltip.add("");
                    tmpTooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:cooldownLeft", (Object[])new Object[]{secondsLeft}));
                }
            } else {
                tmpTooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.waystones:openWaystoneMenu", (Object[])new Object[0]));
                if (secondsLeft > 0) {
                    tmpTooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:cooldownLeft", (Object[])new Object[]{secondsLeft}));
                }
            }
            event.getGui().func_146283_a(tmpTooltip, event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public void onFOV(FOVUpdateEvent event) {
        if (!event.getEntity().func_184607_cu().func_190926_b() && event.getEntity().func_184607_cu().func_77973_b() == Waystones.itemReturnScroll) {
            event.setNewfov((float)event.getEntity().func_184605_cv() / 64.0f * 2.0f + 0.5f);
        }
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity;
        if (id == 1 && (tileEntity = world.func_175625_s(new BlockPos(x, y, z))) instanceof TileWaystone) {
            return new GuiEditWaystone(((TileWaystone)tileEntity).getParent());
        }
        return null;
    }

    @Override
    public void openWaystoneSelection(WarpMode mode, EnumHand hand, @Nullable WaystoneEntry fromWaystone) {
        WaystoneEntry[] waystones = PlayerWaystoneData.fromPlayer((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity()).getWaystones();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWaystoneList(waystones, mode, hand, fromWaystone));
    }

    @Override
    public void playSound(SoundEvent sound, BlockPos pos, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(sound, SoundCategory.AMBIENT, WaystoneConfig.client.soundVolume, pitch, pos));
    }

    @Override
    public boolean isVivecraftInstalled() {
        return this.isVivecraftInstalled;
    }
}

