/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.config.Config;

@Config(modid="waystones", type=Config.Type.INSTANCE, name="Waystones", category="")
@Config.LangKey(value="waystones.config")
public class WaystoneConfig {
    public static General general = new General();
    public static WorldGen worldGen = new WorldGen();
    public static Client client = new Client();

    public static void read(ByteBuf buf) {
        WaystoneConfig.general.teleportButton = buf.readBoolean();
        WaystoneConfig.general.teleportButtonCooldown = buf.readInt();
        WaystoneConfig.general.teleportButtonReturnOnly = buf.readBoolean();
        WaystoneConfig.general.warpStoneCooldown = buf.readInt();
        WaystoneConfig.general.interDimension = buf.readBoolean();
        WaystoneConfig.general.creativeModeOnly = buf.readBoolean();
        WaystoneConfig.general.setSpawnPoint = buf.readBoolean();
        WaystoneConfig.general.restrictRenameToOwner = buf.readBoolean();
        WaystoneConfig.general.blocksPerXPLevel = buf.readInt();
        WaystoneConfig.general.maximumXpCost = buf.readInt();
        WaystoneConfig.general.allowEveryoneGlobal = buf.readBoolean();
    }

    public static void write(ByteBuf buf) {
        buf.writeBoolean(WaystoneConfig.general.teleportButton);
        buf.writeInt(WaystoneConfig.general.teleportButtonCooldown);
        buf.writeBoolean(WaystoneConfig.general.teleportButtonReturnOnly);
        buf.writeInt(WaystoneConfig.general.warpStoneCooldown);
        buf.writeBoolean(WaystoneConfig.general.interDimension);
        buf.writeBoolean(WaystoneConfig.general.creativeModeOnly);
        buf.writeBoolean(WaystoneConfig.general.setSpawnPoint);
        buf.writeBoolean(WaystoneConfig.general.restrictRenameToOwner);
        buf.writeInt(WaystoneConfig.general.blocksPerXPLevel);
        buf.writeInt(WaystoneConfig.general.maximumXpCost);
        buf.writeBoolean(WaystoneConfig.general.allowEveryoneGlobal);
    }

    public static class Client {
        @Config.Name(value="Sound Volume")
        @Config.Comment(value={"The volume of the sound played when teleporting."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float soundVolume = 0.5f;
        @Config.Name(value="Teleport Button GUI X")
        @Config.Comment(value={"The x position of the warp button in the inventory."})
        public int teleportButtonX = 58;
        @Config.Name(value="Teleport Button GUI Y")
        @Config.Comment(value={"The y position of the warp button in the inventory."})
        public int teleportButtonY = 60;
        @Config.Name(value="Disable Particles")
        @Config.Comment(value={"If enabled, activated waystones will not emit particles."})
        public boolean disableParticles = false;
        @Config.Name(value="Disable Text Glow")
        @Config.Comment(value={"If enabled, the text overlay on waystones will no longer always render at full brightness."})
        public boolean disableTextGlow = false;
    }

    public static class WorldGen {
        @Config.Name(value="Generate in Villages")
        @Config.Comment(value={"The chance for a waystone to generate in a village. Set to 1 to always generate one in villages, set to 0 to disable."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public float villageChance = 1.0f;
    }

    public static class General {
        @Config.Name(value="Teleport Button in GUI")
        @Config.Comment(value={"Should there be a button in the inventory to access the waystone menu?"})
        public boolean teleportButton = false;
        @Config.Name(value="Teleport Button Cooldown")
        @Config.Comment(value={"The cooldown between usages of the teleport button in seconds."})
        public int teleportButtonCooldown = 300;
        @Config.Name(value="Teleport Button Return Only")
        @Config.Comment(value={"If enabled, the teleport button will only let you return to the last activated waystone, instead of allowing to choose."})
        public boolean teleportButtonReturnOnly = true;
        @Config.Name(value="Blocks per XP Level")
        @Config.Comment(value={"The amount of blocks per xp level requirement."})
        public int blocksPerXPLevel = 500;
        @Config.Name(value="Maximum XP Cost")
        @Config.Comment(value={"The maximum xp cost when Blocks per XP Level is enabled."})
        @Config.RangeInt(min=1)
        public int maximumXpCost = 3;
        @Config.Name(value="Waystone Costs XP")
        @Config.Comment(value={"If enabled, waystones cost experience when used, based on the distance travelled."})
        public boolean waystoneXpCost = true;
        @Config.Name(value="Inventory Button Costs XP")
        @Config.Comment(value={"If enabled, the inventory button cost experience when used, based on the distance travelled."})
        public boolean inventoryButtonXpCost = false;
        @Config.Name(value="Warp Stone Costs XP")
        @Config.Comment(value={"If enabled, the warp stone costs experience when used, based on the distance travelled."})
        public boolean warpStoneXpCost = false;
        @Config.Name(value="Warp Stone Cooldown")
        @Config.Comment(value={"The cooldown between usages of the warp stone in seconds."})
        public int warpStoneCooldown = 300;
        @Config.Name(value="Interdimensional Teleport")
        @Config.Comment(value={"If enabled, all waystones work inter-dimensionally."})
        public boolean interDimension = true;
        @Config.Name(value="Restrict Rename to Owner")
        @Config.Comment(value={"If enabled, only the owner of a waystone can rename it."})
        public boolean restrictRenameToOwner = false;
        @Config.Name(value="Creative Mode Only")
        @Config.Comment(value={"If enabled, waystones can only be placed in creative mode."})
        public boolean creativeModeOnly;
        @Config.Name(value="Set Spawnpoint on Activation")
        @Config.Comment(value={"If enabled, the player's spawnpoint will be set to the last activated waystone."})
        public boolean setSpawnPoint = false;
        @Config.Name(value="No Cooldown on Global Waystones")
        @Config.Comment(value={"If enabled, waystones marked as global have no cooldown."})
        public boolean globalNoCooldown = true;
        @Config.Name(value="Interdimensional Teleport on Global Waystones")
        @Config.Comment(value={"If enabled, waystones marked as global work inter-dimensionally."})
        public boolean globalInterDimension = true;
        @Config.Name(value="Allow Global Waystones for Everyone")
        @Config.Comment(value={"If enabled, everyone can create global waystones, not just players in creative mode."})
        public boolean allowEveryoneGlobal = false;
        @Config.Name(value="Reset Use On Damage")
        @Config.Comment(value={"Whether the use of a warp stone or warp scroll should be interrupted by damage. Not supported when playing with Vivecraft!"})
        public boolean resetUseOnDamage = false;
    }
}

