/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.proxy;

import c4.conarm.ConstructsArmory;
import c4.conarm.client.utils.GuiHandler;
import c4.conarm.common.ConstructsRegistry;
import c4.conarm.common.RepairRecipe;
import c4.conarm.common.ShapelessPotionRecipe;
import c4.conarm.common.armor.modifiers.ArmorModifiers;
import c4.conarm.common.armor.traits.TraitAquaspeed;
import c4.conarm.common.armor.traits.TraitSuperhot;
import c4.conarm.common.blocks.BlockArmorForge;
import c4.conarm.common.blocks.BlockArmorStation;
import c4.conarm.common.blocks.BlockSoftObsidian;
import c4.conarm.common.events.ArmorEvents;
import c4.conarm.common.events.PlayerDataEvents;
import c4.conarm.common.network.ConstructsNetwork;
import c4.conarm.common.tileentities.TileArmorForge;
import c4.conarm.common.tileentities.TileArmorStation;
import c4.conarm.integrations.tinkertoolleveling.ModArmorLeveling;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.armor.ArmorPart;
import c4.conarm.lib.capabilities.ArmorAbilityHandler;
import c4.conarm.lib.materials.ArmorMaterials;
import c4.conarm.lib.utils.ConstructUtils;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockSeared;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.TableRecipeFactory;
import slimeknights.tconstruct.tools.common.item.ItemBlockTable;

@Mod.EventBusSubscriber
public class CommonProxy {
    public void preInit(FMLPreInitializationEvent evt) {
        ConstructsNetwork.init();
        ArmorMaterials.registerArmorMaterialStats();
    }

    public void init(FMLInitializationEvent evt) {
        ArmoryRegistry.registerAllArmorForging();
        ArmorMaterials.setupArmorMaterials();
        MinecraftForge.EVENT_BUS.register((Object)new ArmorEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ArmorAbilityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerDataEvents());
        CapabilityManager.INSTANCE.register(ArmorAbilityHandler.IArmorAbilities.class, (Capability.IStorage)new ArmorAbilityHandler.Storage(), ArmorAbilityHandler.ArmorAbilities::new);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ConstructsArmory.instance, (IGuiHandler)new GuiHandler());
    }

    public void postInit(FMLPostInitializationEvent evt) {
        ArmorModifiers.registerPolishedModifiers();
        ArmorModifiers.registerExtraTraitModifiers();
        if (Loader.isModLoaded((String)"tinkertoolleveling")) {
            ModArmorLeveling.modArmorLeveling = new ModArmorLeveling();
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> evt) {
        IForgeRegistry registry = evt.getRegistry();
        ConstructsRegistry.armorForge = ConstructUtils.registerBlock((IForgeRegistry<Block>)registry, new BlockArmorForge(), "armorforge");
        ConstructsRegistry.armorStation = ConstructUtils.registerBlock((IForgeRegistry<Block>)registry, new BlockArmorStation(), "armorstation");
        ConstructsRegistry.softObsidian = ConstructUtils.registerBlock((IForgeRegistry<Block>)registry, new BlockSoftObsidian(), "soft_obsidian");
        GameRegistry.registerTileEntity(TileArmorStation.class, (String)"armorstation");
        GameRegistry.registerTileEntity(TileArmorForge.class, (String)"armorforge");
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> evt) {
        IForgeRegistry registry = evt.getRegistry();
        ConstructsRegistry.registerArmorParts((IForgeRegistry<Item>)registry);
        ConstructsRegistry.registerArmorPieces((IForgeRegistry<Item>)registry);
        ConstructsRegistry.registerItems((IForgeRegistry<Item>)registry);
        ArmorModifiers.setupModifiers();
        ConstructsRegistry.armorForge = (BlockArmorForge)((Object)ConstructUtils.registerItemBlock((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockTable((Block)ConstructsRegistry.armorForge)));
        ConstructsRegistry.armorStation = (BlockArmorStation)((Object)ConstructUtils.registerItemBlock((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockTable((Block)ConstructsRegistry.armorStation)));
        for (Pair<Item, ArmorPart> armorPartPattern : ConstructsRegistry.armorPartPatterns) {
            CommonProxy.registerStencil((Item)armorPartPattern.getLeft(), (ArmorPart)((Object)armorPartPattern.getRight()));
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        if (ConstructsRegistry.armorForge != null) {
            ConstructsRegistry.armorForge.baseBlocks.addAll(TinkerTools.toolForge.baseBlocks);
            for (String oredict : ConstructsRegistry.armorForge.baseBlocks) {
                BlockSeared brick = TinkerSmeltery.searedBlock;
                if (brick == null) {
                    brick = Blocks.field_150417_aV;
                }
                TableRecipeFactory.TableRecipe recipe = new TableRecipeFactory.TableRecipe(new ResourceLocation("conarm", "armorforge"), (Ingredient)new OreIngredient(oredict), new ItemStack((Block)ConstructsRegistry.armorForge), CraftingHelper.parseShaped((Object[])new Object[]{"BBB", "MTM", "M M", Character.valueOf('B'), brick, Character.valueOf('M'), oredict, Character.valueOf('T'), ConstructsRegistry.armorStation}));
                recipe.setRegistryName("armorforge_" + oredict.toLowerCase(Locale.US));
                registry.register((IForgeRegistryEntry)recipe);
            }
        }
        registry.register((IForgeRegistryEntry)new RepairRecipe());
        registry.register(new ShapelessPotionRecipe((NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185234_f)}), Ingredient.func_193367_a((Item)Items.field_151150_bK), Ingredient.func_193367_a((Item)Items.field_151033_d), Ingredient.func_193367_a((Item)ConstructsRegistry.travelGoggles)}), new ItemStack((Item)ConstructsRegistry.travelNight)).setRegistryName("travel_night"));
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])new Potion[]{TraitSuperhot.superhotPotion, TraitAquaspeed.aquaspeedPotion});
    }

    private static void registerStencil(Item pattern, ArmorPart armorPart) {
        for (ArmorCore armorCore : ArmoryRegistry.getArmor()) {
            for (PartMaterialType partMaterialType : armorCore.getRequiredComponents()) {
                if (!partMaterialType.getPossibleParts().contains((Object)armorPart)) continue;
                ItemStack stencil = new ItemStack(pattern);
                Pattern.setTagForPart((ItemStack)stencil, (Item)armorPart);
                TinkerRegistry.registerStencilTableCrafting((ItemStack)stencil);
                return;
            }
        }
    }
}

