/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.utils;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.modifiers.IModifier;

public class RecipeMatchHolder {
    private static final Map<IModifier, PriorityQueue<RecipeMatch>> recipes = Maps.newHashMap();

    public static Optional<PriorityQueue<RecipeMatch>> getRecipes(IModifier modifier) {
        return Optional.of(recipes.get(modifier));
    }

    public static Optional<RecipeMatch.Match> matches(IModifier modifier, NonNullList<ItemStack> stacks) {
        if (recipes.get(modifier) != null) {
            PriorityQueue<RecipeMatch> matchHolder = recipes.get(modifier);
            for (RecipeMatch recipe : matchHolder) {
                Optional match = recipe.matches(stacks);
                if (!match.isPresent()) continue;
                return match;
            }
        }
        return Optional.empty();
    }

    public static void addRecipeMatch(IModifier modifier, RecipeMatch recipe) {
        recipes.putIfAbsent(modifier, new PriorityQueue<RecipeMatch>(1, RecipeComparator.INSTANCE));
        PriorityQueue<RecipeMatch> recipeMatches = recipes.get(modifier);
        if (recipeMatches != null) {
            recipeMatches.add(recipe);
        }
    }

    public static void addItem(IModifier modifier, String oredictItem, int amountNeeded, int amountMatched) {
        RecipeMatchHolder.addRecipeMatch(modifier, (RecipeMatch)new RecipeMatch.Oredict(oredictItem, amountNeeded, amountMatched));
    }

    public static void addItem(IModifier modifier, String oredictItem) {
        RecipeMatchHolder.addItem(modifier, oredictItem, 1, 1);
    }

    public static void addItem(IModifier modifier, Block block, int amountMatched) {
        RecipeMatchHolder.addRecipeMatch(modifier, (RecipeMatch)new RecipeMatch.Item(new ItemStack(block), 1, amountMatched));
    }

    public static void addItem(IModifier modifier, Item item, int amountNeeded, int amountMatched) {
        RecipeMatchHolder.addRecipeMatch(modifier, (RecipeMatch)new RecipeMatch.Item(new ItemStack(item), amountNeeded, amountMatched));
    }

    public static void addItem(IModifier modifier, ItemStack item, int amountNeeded, int amountMatched) {
        RecipeMatchHolder.addRecipeMatch(modifier, (RecipeMatch)new RecipeMatch.Item(item, amountNeeded, amountMatched));
    }

    public static void addItem(IModifier modifier, Item item) {
        RecipeMatchHolder.addItem(modifier, item, 1, 1);
    }

    private static class RecipeComparator
    implements Comparator<RecipeMatch> {
        public static RecipeComparator INSTANCE = new RecipeComparator();

        private RecipeComparator() {
        }

        @Override
        public int compare(RecipeMatch o1, RecipeMatch o2) {
            return o2.amountMatched - o1.amountMatched;
        }
    }
}

