/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.tinkering;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.materials.CoreMaterialStats;
import c4.conarm.lib.materials.PlatesMaterialStats;
import c4.conarm.lib.modifiers.AccessoryModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TooltipBuilder;

public class ArmorTooltipBuilder {
    public static void addDefense(TooltipBuilder info, ItemStack stack) {
        info.add(CoreMaterialStats.formatDefense(ArmorHelper.getDefense(stack)));
    }

    public static void addToughness(TooltipBuilder info, ItemStack stack) {
        info.add(PlatesMaterialStats.formatToughness(ArmorHelper.getToughness(stack)));
    }

    public static void addModifierTooltips(ItemStack stack, List<String> tooltips) {
        NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)stack);
        ArrayList<String> toAdd = new ArrayList<String>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)tag);
            IModifier modifier = TinkerRegistry.getModifier((String)data.identifier);
            if (modifier == null || modifier.isHidden()) continue;
            if (modifier instanceof AccessoryModifier) {
                tooltips.add(data.getColorString() + String.format(Util.translate((String)"accessory.tooltip", (Object[])new Object[0]), modifier.getTooltip(tag, false)));
                continue;
            }
            toAdd.add(data.getColorString() + modifier.getTooltip(tag, false));
        }
        tooltips.addAll(toAdd);
    }
}

