/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.modifiers;

import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.tinkering.TinkersArmor;
import c4.conarm.lib.traits.AbstractArmorTrait;
import c4.conarm.lib.utils.RecipeMatchHolder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IModifierDisplay;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ArmorModifierTrait
extends AbstractArmorTrait
implements IModifierDisplay {
    protected final int maxLevel;

    public ArmorModifierTrait(String identifier, int color) {
        this(identifier, color, 0, 0);
    }

    public ArmorModifierTrait(String identifier, int color, int maxLevel, int countPerLevel) {
        super(identifier, color);
        TinkerRegistry.addTrait((ITrait)this);
        ArmoryRegistry.registerModifier((IModifier)this);
        this.maxLevel = maxLevel;
        this.aspects.clear();
        if (maxLevel > 0 && countPerLevel > 0) {
            this.addAspects(new ModifierAspect[]{new ModifierAspect.MultiAspect((IModifier)this, color, maxLevel, countPerLevel, 1)});
        } else {
            if (maxLevel > 0) {
                this.addAspects(new ModifierAspect[]{new ModifierAspect.LevelAspect((IModifier)this, maxLevel)});
            }
            this.addAspects(new ModifierAspect[]{new ModifierAspect.DataAspect((IModifier)this, color)});
            this.addAspects(new ModifierAspect[]{ModifierAspect.freeModifier});
        }
    }

    public boolean canApplyCustom(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof TinkersArmor)) {
            return false;
        }
        if (super.canApplyCustom(stack)) {
            return true;
        }
        if (this.maxLevel == 0) {
            return false;
        }
        NBTTagCompound tag = TinkerUtil.getModifierTag((ItemStack)stack, (String)this.identifier);
        return ModifierNBT.readTag((NBTTagCompound)tag).level <= this.maxLevel;
    }

    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        if (this.maxLevel > 0) {
            return this.getLeveledTooltip(modifierTag, detailed);
        }
        return super.getTooltip(modifierTag, detailed);
    }

    public int getColor() {
        return this.color;
    }

    public List<List<ItemStack>> getItems() {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional<PriorityQueue<RecipeMatch>> recipes = RecipeMatchHolder.getRecipes((IModifier)this);
        if (recipes.isPresent()) {
            PriorityQueue<RecipeMatch> recipeMatches = recipes.get();
            for (RecipeMatch rm : recipeMatches) {
                List in = rm.getInputs();
                if (in.isEmpty()) continue;
                builder.add((Object)in);
            }
        }
        return builder.build();
    }
}

