/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.common.armor.traits.TraitUtils;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.traits.AbstractArmorTrait;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.ModifierTagHolder;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.tools.TinkerTools;

public class TraitVoltaic
extends AbstractArmorTrait {
    public TraitVoltaic() {
        super("voltaic", 0xFFFFFF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent evt) {
        if (evt.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)evt.getEntityLiving();
            int level = 0;
            for (ItemStack armor : player.func_184193_aE()) {
                if (!(armor.func_77973_b() instanceof ArmorCore) || !TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)armor), (String)this.identifier)) continue;
                ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)armor, (String)this.getModifierIdentifier());
                ChargeData data = (ChargeData)modtag.getTagData(ChargeData.class);
                if (!(data.charge >= 25.0f)) continue;
                ++level;
                this.discharge(armor, modtag, data);
            }
            if (level > 0) {
                if (player instanceof EntityPlayerMP) {
                    Sounds.playSoundForAll((Entity)player, (SoundEvent)Sounds.shocking_discharge, (float)1.0f, (float)1.0f);
                }
                double radius = 2.0 * (double)level;
                BlockPos pos = player.func_180425_c();
                List entities = player.field_70170_p.func_175674_a((Entity)player, new AxisAlignedBB((double)pos.func_177958_n() - radius, (double)pos.func_177956_o() - radius, (double)pos.func_177952_p() - radius, (double)pos.func_177958_n() + radius, (double)pos.func_177956_o() + radius, (double)pos.func_177952_p() + radius), TraitUtils.IS_LIVING);
                for (Entity entity : entities) {
                    if (!TraitVoltaic.attackEntitySecondary((DamageSource)new EntityDamageSource("lightningBolt", (Entity)player).func_180138_v(), (float)(2.0f * (float)level), (Entity)entity, (boolean)false, (boolean)true, (boolean)false)) continue;
                    TinkerTools.proxy.spawnEffectParticle(ParticleEffect.Type.HEART_ELECTRO, entity, 5);
                }
            }
        }
    }

    @Override
    public float onHurt(ItemStack armor, EntityPlayer player, DamageSource source, float damage, float newDamage, LivingHurtEvent evt) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)armor, (String)this.getModifierIdentifier());
        ChargeData data = (ChargeData)modtag.getTagData(ChargeData.class);
        if (source == DamageSource.field_180137_b) {
            this.addCharge(25.0f, armor, (Entity)player, data);
            modtag.save();
            return newDamage -= damage * 0.25f;
        }
        if (data.charge < 25.0f) {
            this.addCharge(damage * 0.25f, armor, (Entity)player, data);
            modtag.save();
        }
        return newDamage;
    }

    private void addCharge(float change, ItemStack armor, Entity entity, ChargeData data) {
        data.charge += change;
        if (data.charge >= 25.0f) {
            TagUtil.setEnchantEffect((ItemStack)armor, (boolean)true);
            if (entity instanceof EntityPlayerMP) {
                Sounds.PlaySoundForPlayer((Entity)entity, (SoundEvent)Sounds.shocking_charged, (float)0.8f, (float)(0.8f + 0.2f * random.nextFloat()));
            }
        }
    }

    private void discharge(ItemStack armor, ModifierTagHolder modtag, ChargeData data) {
        data.charge = 0.0f;
        modtag.save();
        TagUtil.setEnchantEffect((ItemStack)armor, (boolean)false);
    }

    public static class ChargeData
    extends ModifierNBT {
        float charge;

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.charge = tag.func_74760_g("charge");
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74776_a("charge", this.charge);
        }
    }
}

