/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.tinkering.TinkersArmor;
import c4.conarm.lib.traits.AbstractArmorTrait;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.ModifierTagHolder;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitCalcic
extends AbstractArmorTrait {
    public TraitCalcic() {
        super("calcic", 0xFFFFFF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent.Start evt) {
        if (evt.getItem().func_77973_b() instanceof ItemBucketMilk && evt.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)evt.getEntityLiving();
            for (ItemStack armor : player.func_184193_aE()) {
                if (!(armor.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)armor) || !TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)armor), (String)this.getModifierIdentifier())) continue;
                ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)armor, (String)this.getModifierIdentifier());
                Data data = (Data)modtag.getTagData(Data.class);
                data.milk = true;
                modtag.save();
            }
        }
    }

    @SubscribeEvent
    public void finishMilk(LivingEntityUseItemEvent.Finish evt) {
        if (evt.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)evt.getEntityLiving();
            int level = 0;
            for (ItemStack armor : player.func_184193_aE()) {
                if (!(armor.func_77973_b() instanceof TinkersArmor) || ToolHelper.isBroken((ItemStack)armor) || !TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)armor), (String)this.getModifierIdentifier())) continue;
                ArmorHelper.healArmor(armor, 10, player, EntityLiving.func_184640_d((ItemStack)armor).func_188454_b());
                ++level;
                ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)armor, (String)this.getModifierIdentifier());
                Data data = (Data)modtag.getTagData(Data.class);
                data.milk = false;
                modtag.save();
            }
            if (level > 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100 * level, level - 1));
            }
        }
    }

    public static class Data
    extends ModifierNBT {
        boolean milk;

        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.milk = tag.func_74767_n("milk");
        }

        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74757_a("milk", this.milk);
        }
    }
}

