/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.traits;

import c4.conarm.lib.traits.AbstractArmorTrait;
import c4.conarm.lib.utils.ConstructUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.potion.TinkerPotion;

public class TraitAquaspeed
extends AbstractArmorTrait {
    public static TinkerPotion aquaspeedPotion = new AquaspeedPotion();
    private static final double SPEED_MOD = 0.05;

    public TraitAquaspeed() {
        super("aquaspeed", TextFormatting.AQUA);
    }

    @Override
    public void onAbilityTick(int level, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70090_H()) {
            aquaspeedPotion.apply((EntityLivingBase)player, 5, level);
        }
    }

    private static class AquaspeedPotion
    extends TinkerPotion {
        AquaspeedPotion() {
            super(ConstructUtils.getResource("aquaspeedPotion"), false, false);
        }

        public boolean func_76397_a(int duration, int strength) {
            return true;
        }

        public void func_76394_a(@Nonnull EntityLivingBase entity, int level) {
            if (entity.func_70090_H()) {
                double motionX = entity.field_70159_w * (1.0 + 0.05 * (double)level);
                double motionY = entity.field_70181_x * (1.0 + 0.05 * (double)level);
                double motionZ = entity.field_70179_y * (1.0 + 0.05 * (double)level);
                boolean isFlying = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b;
                double maxSpeed = 1.1 + (double)(level - 1) / 15.0;
                if (!isFlying) {
                    if (Math.abs(motionX) < maxSpeed) {
                        entity.field_70159_w = motionX;
                    }
                    if (Math.abs(motionY) < maxSpeed) {
                        entity.field_70181_x = motionY;
                    }
                    if (Math.abs(motionZ) < maxSpeed) {
                        entity.field_70179_y = motionZ;
                    }
                }
            }
        }
    }
}

