/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers;

import c4.conarm.lib.modifiers.ArmorModifierTrait;
import java.util.ListIterator;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModResistantType
extends ArmorModifierTrait {
    private static final float BASE_REDUCTION = 0.02f;
    private static final float MAX_REDUCTION = 0.8f;
    private final EnchantmentProtection.Type type;

    public ModResistantType(String identifier, int color, EnchantmentProtection.Type type) {
        super(identifier, color, 8, 0);
        this.type = type;
        ListIterator<ModifierAspect.FreeFirstModifierAspect> iter = this.aspects.listIterator();
        while (iter.hasNext()) {
            if (iter.next() != ModifierAspect.freeModifier) continue;
            iter.set(new ModifierAspect.FreeFirstModifierAspect((IModifier)this, 1));
        }
    }

    @Override
    public float onDamaged(ItemStack armor, EntityPlayer player, DamageSource source, float damage, float newDamage, LivingDamageEvent evt) {
        float reduction = 0.0f;
        NBTTagCompound tag = TinkerUtil.getModifierTag((ItemStack)armor, (String)this.identifier);
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger((NBTTagCompound)tag);
        if (this.type == EnchantmentProtection.Type.EXPLOSION && source.func_94541_c()) {
            reduction = 0.04f;
        } else if (this.type == EnchantmentProtection.Type.FIRE && source.func_76347_k()) {
            reduction = 0.04f;
        } else if (this.type == EnchantmentProtection.Type.PROJECTILE && source.func_76352_a()) {
            reduction = 0.04f;
        } else if (this.type == EnchantmentProtection.Type.ALL) {
            reduction = 0.02f;
        }
        return newDamage -= damage * reduction * (float)data.level;
    }

    public boolean canApplyTogether(IToolMod mod) {
        return this == mod || !(mod instanceof ModResistantType);
    }
}

