/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers;

import c4.conarm.common.armor.utils.ArmorHelper;
import c4.conarm.lib.modifiers.ArmorModifierTrait;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.ModifierTagHolder;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.modifiers.ModMendingMoss;

public class ModMending
extends ArmorModifierTrait {
    private static final int DELAY = 600;

    public ModMending() {
        super("mending", 4434738, 3, 0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onUpdate(ItemStack armor, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_71071_by.field_70460_b.contains((Object)armor) && this.needsRepair(armor) && this.useXp(armor, world)) {
                ArmorHelper.healArmor(armor, this.getDurabilityPerXP(armor), player, EntityLiving.func_184640_d((ItemStack)armor).func_188454_b());
            }
        }
    }

    @SubscribeEvent
    public void onPickupXp(PlayerPickupXpEvent evt) {
        EntityXPOrb entityXPOrb = evt.getOrb();
        for (ItemStack itemStack : evt.getEntityPlayer().func_184193_aE()) {
            if (itemStack.func_190926_b() || !this.isMendingMossModified(itemStack)) continue;
            int stored = this.storeXp(entityXPOrb.field_70530_e, itemStack);
            entityXPOrb.field_70530_e -= stored;
        }
    }

    private boolean isMendingMossModified(ItemStack itemStack) {
        return TinkerUtil.hasModifier((NBTTagCompound)TagUtil.getTagSafe((ItemStack)itemStack), (String)this.getModifierIdentifier());
    }

    private boolean needsRepair(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.func_77952_i() > 0 && !ToolHelper.isBroken((ItemStack)itemStack);
    }

    private int getDurabilityPerXP(ItemStack itemStack) {
        return 2 + ((ModMendingMoss.Data)ModifierTagHolder.getModifier((ItemStack)itemStack, (String)this.getModifierIdentifier()).getTagData(ModMendingMoss.Data.class)).level;
    }

    private int getMaxXp(int level) {
        if (level <= 1) {
            return 30;
        }
        return this.getMaxXp(level - 1) * 3;
    }

    private boolean canStoreXp(ModMendingMoss.Data data) {
        return data.storedXp < this.getMaxXp(data.level);
    }

    private int storeXp(int amount, ItemStack itemStack) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)itemStack, (String)this.getModifierIdentifier());
        ModMendingMoss.Data data = (ModMendingMoss.Data)modtag.getTagData(ModMendingMoss.Data.class);
        int change = 0;
        if (this.canStoreXp(data)) {
            int max = this.getMaxXp(data.level);
            change = Math.min(amount, max - data.storedXp);
            data.storedXp += change;
            modtag.save();
        }
        return change;
    }

    private boolean useXp(ItemStack itemStack, World world) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier((ItemStack)itemStack, (String)this.getModifierIdentifier());
        ModMendingMoss.Data data = (ModMendingMoss.Data)modtag.getTagData(ModMendingMoss.Data.class);
        if (data.storedXp > 0 && world.func_82737_E() - data.lastHeal > 600L) {
            --data.storedXp;
            data.lastHeal = world.func_82737_E();
            modtag.save();
            return true;
        }
        return false;
    }

    public List<String> getExtraInfo(ItemStack armor, NBTTagCompound modifierTag) {
        ModMendingMoss.Data data = (ModMendingMoss.Data)ModifierNBT.readTag((NBTTagCompound)modifierTag, ModMendingMoss.Data.class);
        assert (data != null);
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        return ImmutableList.of((Object)Util.translateFormatted((String)loc, (Object[])new Object[]{data.storedXp}));
    }
}

