/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.client.gui;

import c4.conarm.ConstructsArmory;
import c4.conarm.client.gui.GuiButtonArmorRepair;
import c4.conarm.client.gui.GuiButtonsArmorStation;
import c4.conarm.client.gui.GuiPreviewPanel;
import c4.conarm.client.gui.PreviewPlayer;
import c4.conarm.common.inventory.ContainerArmorStation;
import c4.conarm.common.inventory.SlotArmorStationIn;
import c4.conarm.common.network.ArmorStationSelectionPacket;
import c4.conarm.common.network.ArmorStationTextPacket;
import c4.conarm.common.tileentities.TileArmorStation;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.ArmoryRegistryClient;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.client.ArmorBuildGuiInfo;
import c4.conarm.lib.modifiers.IArmorModifyable;
import c4.conarm.lib.tinkering.TinkersArmor;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.Point;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.IToolStationDisplay;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.common.client.GuiTinkerStation;
import slimeknights.tconstruct.tools.common.client.module.GuiInfoPanel;
import slimeknights.tconstruct.tools.common.inventory.ContainerTinkerStation;

@SideOnly(value=Side.CLIENT)
public class GuiArmorStation
extends GuiTinkerStation {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("conarm", "textures/gui/armorforge.png");
    private static final ResourceLocation ICONS = new ResourceLocation("conarm", "textures/gui/icons.png");
    private static final GuiElement TextFieldActive = new GuiElement(0, 210, 92, 12, 256, 256);
    private static final GuiElement ItemCover = new GuiElement(176, 18, 80, 64);
    private static final GuiElement SlotBackground = new GuiElement(176, 0, 18, 18);
    private static final GuiElement SlotBorder = new GuiElement(194, 0, 18, 18);
    private static final GuiElement SlotSpaceTop = new GuiElement(0, 176, 18, 2);
    private static final GuiElement SlotSpaceBottom = new GuiElement(0, 174, 18, 2);
    private static final GuiElement PanelSpaceL = new GuiElement(0, 174, 5, 4);
    private static final GuiElement PanelSpaceR = new GuiElement(9, 174, 9, 4);
    private static final GuiElement BeamLeft = new GuiElement(0, 180, 2, 7);
    private static final GuiElement BeamRight = new GuiElement(131, 180, 2, 7);
    private static final GuiElementScalable BeamCenter = new GuiElementScalable(2, 180, 129, 7);
    public static final int Column_Count = 5;
    private static final int Table_slot_count = 6;
    protected GuiElement buttonDecorationTop = SlotSpaceTop;
    protected GuiElement buttonDecorationBot = SlotSpaceBottom;
    protected GuiElement panelDecorationL = PanelSpaceL;
    protected GuiElement panelDecorationR = PanelSpaceR;
    protected GuiElement beamL = new GuiElement(0, 0, 0, 0);
    protected GuiElement beamR = new GuiElement(0, 0, 0, 0);
    protected GuiElementScalable beamC = new GuiElementScalable(0, 0, 0, 0);
    protected GuiButtonsArmorStation buttons;
    protected int activeSlots;
    public GuiTextField textField;
    protected GuiInfoPanel armorInfo;
    protected GuiInfoPanel traitInfo;
    protected GuiPreviewPanel armorPreview;
    public ArmorBuildGuiInfo currentInfo = GuiButtonArmorRepair.info;
    private static final Field GUI_TOP = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"guiTop", "field_147009_r"});
    private static final Field BUTTON_LIST = ReflectionHelper.findField(GuiScreen.class, (String[])new String[]{"buttonList", "field_146292_n"});

    public GuiArmorStation(InventoryPlayer playerInv, World world, BlockPos pos, TileArmorStation tile) {
        super(world, pos, (ContainerTinkerStation)tile.createContainer(playerInv, world, pos));
        this.buttons = new GuiButtonsArmorStation(this, this.field_147002_h);
        this.addModule((GuiModule)this.buttons);
        this.armorInfo = new GuiInfoPanel((GuiMultiModule)this, this.field_147002_h);
        this.addModule((GuiModule)this.armorInfo);
        this.traitInfo = new GuiInfoPanel((GuiMultiModule)this, this.field_147002_h);
        this.addModule((GuiModule)this.traitInfo);
        this.armorPreview = new GuiPreviewPanel((GuiMultiModule)this, this.field_147002_h, 106, this.field_147000_g - 16, new PreviewPlayer(world, (AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g));
        this.addModule((GuiModule)this.armorPreview);
        this.armorInfo.yOffset = 5;
        this.traitInfo.yOffset = this.armorInfo.getYSize() + 9;
        this.armorPreview.yOffset = 5;
        this.armorPreview.setCaption(Util.translate((String)"gui.armorstation.preview", (Object[])new Object[0]));
        this.armorPreview.setText(new String[0]);
        this.field_147000_g = 174;
        this.wood();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_147009_r += 4;
        this.cornerY += 4;
        this.textField = new GuiTextField(0, this.field_146289_q, this.cornerX + 80, this.cornerY + 7, 82, 12);
        this.textField.func_146185_a(false);
        this.textField.func_146203_f(40);
        this.buttons.xOffset = -2;
        this.buttons.yOffset = this.beamC.h + this.buttonDecorationTop.h;
        this.armorInfo.xOffset = 2;
        this.armorInfo.yOffset = this.beamC.h + this.panelDecorationL.h;
        this.traitInfo.xOffset = this.armorInfo.xOffset;
        this.traitInfo.yOffset = this.armorInfo.yOffset + this.armorInfo.getYSize() + 4;
        this.armorPreview.yOffset = this.beamC.h + this.buttonDecorationTop.h * 3 + this.buttons.getYSize();
        this.armorPreview.xOffset = -284;
        for (GuiModule module : this.modules) {
            try {
                GUI_TOP.setInt(module, module.getGuiTop() + 4);
            }
            catch (IllegalAccessException e) {
                ConstructsArmory.logger.error("Failed to set guiTop");
            }
        }
        this.updateGUI();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.armorPreview.oldMouseX = mouseX;
        this.armorPreview.oldMouseY = mouseY;
    }

    public Set<ArmorCore> getBuildableItems() {
        return ArmoryRegistry.getArmorCrafting();
    }

    public void onArmorSelection(ArmorBuildGuiInfo info) {
        this.activeSlots = Math.min(info.positions.size(), 6);
        this.currentInfo = info;
        ArmorCore armor = null;
        if (info.armor.func_77973_b() instanceof ArmorCore) {
            armor = (ArmorCore)info.armor.func_77973_b();
        }
        ((ContainerArmorStation)this.field_147002_h).setArmorSelection(armor, this.activeSlots);
        TinkerNetwork.sendToServer((AbstractPacket)new ArmorStationSelectionPacket(armor, this.activeSlots));
        this.updateGUI();
    }

    public void onArmorSelectionPacket(ArmorStationSelectionPacket packet) {
        ArmorBuildGuiInfo info = ArmoryRegistryClient.getArmorBuildInfoForArmor((Item)packet.armor);
        if (info == null) {
            info = GuiButtonArmorRepair.info;
        }
        this.activeSlots = packet.activeSlots;
        this.currentInfo = info;
        this.buttons.setSelectedButtonByArmor(this.currentInfo.armor);
        this.updateGUI();
    }

    public void updateGUI() {
        Slot slot;
        int i;
        for (i = 0; i < this.activeSlots; ++i) {
            Point point = this.currentInfo.positions.get(i);
            slot = this.field_147002_h.func_75139_a(i);
            slot.field_75223_e = point.getX();
            slot.field_75221_f = point.getY();
        }
        int stillFilled = 0;
        while (i < 6) {
            slot = this.field_147002_h.func_75139_a(i);
            if (slot.func_75216_d()) {
                slot.field_75223_e = 87 + 20 * stillFilled;
                slot.field_75221_f = 62;
                ++stillFilled;
            } else {
                slot.field_75223_e = 0;
                slot.field_75221_f = 0;
            }
            ++i;
        }
        this.updateDisplay();
    }

    public void updateDisplay() {
        ContainerArmorStation container = (ContainerArmorStation)this.field_147002_h;
        ItemStack armorStack = container.getResult();
        if (armorStack.func_190926_b()) {
            armorStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        }
        if (armorStack.func_77973_b() instanceof IArmorModifyable) {
            if (armorStack.func_77973_b() instanceof IToolStationDisplay) {
                IToolStationDisplay armor = (IToolStationDisplay)armorStack.func_77973_b();
                this.armorInfo.setCaption(armor.getLocalizedName());
                this.armorInfo.setText(armor.getInformation(armorStack));
            } else {
                this.armorInfo.setCaption(armorStack.func_82833_r());
                this.armorInfo.setText(new String[0]);
            }
            this.armorPreview.givePreviewStack(armorStack);
            this.traitInfo.setCaption(Util.translate((String)"gui.toolstation.traits", (Object[])new Object[0]));
            LinkedList mods = Lists.newLinkedList();
            LinkedList tips = Lists.newLinkedList();
            NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)armorStack);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)tag);
                IModifier modifier = ArmoryRegistry.getArmorModifier(data.identifier);
                if (modifier == null) {
                    modifier = TinkerRegistry.getModifier((String)data.identifier);
                }
                if (modifier == null || modifier.isHidden()) continue;
                mods.add(data.getColorString() + modifier.getTooltip(tag, true));
                tips.add(data.getColorString() + modifier.getLocalizedDesc());
            }
            if (mods.isEmpty()) {
                mods.add(Util.translate((String)"gui.toolstation.noTraits", (Object[])new Object[0]));
            }
            this.traitInfo.setText((List)mods, (List)tips);
        } else if (this.currentInfo.armor.func_190926_b()) {
            this.armorPreview.resetPreview();
            this.armorInfo.setCaption(Util.translate((String)"gui.toolstation.repair", (Object[])new Object[0]));
            this.armorInfo.setText(new String[0]);
            this.traitInfo.setCaption(null);
            String c = TextFormatting.DARK_GRAY.toString();
            String[] art = new String[]{c + "", c + "", c + "       .", c + "     /( _________", c + "     |  >:=========`", c + "     )(  ", c + "     \"\""};
            this.traitInfo.setText(art);
        } else {
            ArmorCore armor = (ArmorCore)this.currentInfo.armor.func_77973_b();
            this.armorInfo.setCaption(armor.getLocalizedToolName());
            this.armorInfo.setText(new String[]{armor.getLocalizedDescription()});
            LinkedList text = Lists.newLinkedList();
            List<PartMaterialType> pms = armor.getRequiredComponents();
            for (int i = 0; i < pms.size(); ++i) {
                PartMaterialType pmt = pms.get(i);
                StringBuilder sb = new StringBuilder();
                ItemStack slotStack = container.func_75139_a(i).func_75211_c();
                if (!pmt.isValid(slotStack)) {
                    sb.append(TextFormatting.RED);
                    if (slotStack.func_77973_b() instanceof IToolPart && pmt.isValidItem((IToolPart)slotStack.func_77973_b())) {
                        this.warning(Util.translate((String)"gui.error.wrong_material_part", (Object[])new Object[0]));
                    }
                }
                sb.append(" * ");
                for (IToolPart part : pmt.getPossibleParts()) {
                    if (!(part instanceof Item)) continue;
                    sb.append(((Item)part).func_77653_i(new ItemStack((Item)part)));
                    sb.append("/");
                }
                sb.deleteCharAt(sb.length() - 1);
                text.add(sb.toString());
            }
            this.traitInfo.setCaption(Util.translate((String)"gui.toolstation.components", (Object[])new Object[0]));
            this.traitInfo.setText(text.toArray(new String[text.size()]));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.textField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.textField.func_146206_l()) {
            super.func_73869_a(typedChar, keyCode);
        } else {
            if (keyCode == 1) {
                this.field_146297_k.field_71439_g.func_71053_j();
            }
            this.textField.func_146201_a(typedChar, keyCode);
            TinkerNetwork.sendToServer((AbstractPacket)new ArmorStationTextPacket(this.textField.func_146179_b()));
            ((ContainerArmorStation)this.container).setArmorName(this.textField.func_146179_b());
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.textField.func_146178_a();
    }

    public void func_146977_a(Slot slotIn) {
        if (slotIn instanceof SlotArmorStationIn && ((SlotArmorStationIn)slotIn).isDormant() && !slotIn.func_75216_d()) {
            return;
        }
        super.func_146977_a(slotIn);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        this.drawBackground(BACKGROUND);
        if (this.textField.func_146206_l()) {
            TextFieldActive.draw(this.cornerX + 78, this.cornerY + 6);
        }
        this.textField.func_146194_f();
        int x = 0;
        int y = 0;
        float scale = 3.7f;
        float xOff = 10.0f;
        float yOff = 22.0f;
        GlStateManager.func_179109_b((float)10.0f, (float)22.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)3.7f, (float)3.7f, (float)1.0f);
        int logoX = (int)((float)this.cornerX / 3.7f);
        int logoY = (int)((float)this.cornerY / 3.7f);
        if (this.currentInfo != null) {
            if (!this.currentInfo.armor.func_190926_b()) {
                this.field_146296_j.func_175042_a(this.currentInfo.armor, logoX, logoY);
            } else if (this.currentInfo == GuiButtonArmorRepair.info) {
                this.field_146297_k.func_110434_K().func_110577_a(Icons.ICON);
                Icons.ICON_Anvil.draw(logoX, logoY);
            }
        }
        GlStateManager.func_179152_a((float)0.27027026f, (float)0.27027026f, (float)1.0f);
        GlStateManager.func_179109_b((float)-10.0f, (float)-22.0f, (float)0.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.82f);
        ItemCover.draw(this.cornerX + 7, this.cornerY + 18);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.28f);
        for (i = 0; i < this.activeSlots; ++i) {
            Slot slot = this.field_147002_h.func_75139_a(i);
            SlotBackground.draw(x + this.cornerX + slot.field_75223_e - 1, y + this.cornerY + slot.field_75221_f - 1);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i < 6; ++i) {
            Slot slot = this.field_147002_h.func_75139_a(i);
            if (!(slot instanceof SlotArmorStationIn) || ((SlotArmorStationIn)slot).isDormant() && !slot.func_75216_d()) continue;
            SlotBorder.draw(x + this.cornerX + slot.field_75223_e - 1, y + this.cornerY + slot.field_75221_f - 1);
        }
        this.field_146297_k.func_110434_K().func_110577_a(Icons.ICON);
        if (this.currentInfo == GuiButtonArmorRepair.info) {
            this.drawRepairSlotIcons();
        } else if (this.currentInfo.armor.func_77973_b() instanceof TinkersArmor) {
            for (i = 0; i < this.activeSlots; ++i) {
                ItemStack stack;
                Slot slot = this.field_147002_h.func_75139_a(i);
                if (!(slot instanceof SlotArmorStationIn) || (stack = ((SlotArmorStationIn)slot).icon) == null) continue;
                this.field_146296_j.func_175042_a(stack, x + this.cornerX + slot.field_75223_e, y + this.cornerY + slot.field_75221_f);
            }
        }
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        x = this.buttons.getGuiLeft() - this.beamL.w;
        y = this.cornerY;
        x += this.beamL.draw(x, y);
        x += this.beamC.drawScaledX(x, y, this.buttons.getXSize());
        this.beamR.draw(x, y);
        x = this.armorInfo.getGuiLeft() - this.beamL.w;
        x += this.beamL.draw(x, y);
        x += this.beamC.drawScaledX(x, y, this.armorInfo.getXSize());
        this.beamR.draw(x, y);
        List buttonList = Lists.newLinkedList();
        try {
            buttonList = (List)BUTTON_LIST.get((Object)this.buttons);
        }
        catch (IllegalAccessException e) {
            ConstructsArmory.logger.log(Level.ERROR, "Failed to initialize buttonList");
        }
        for (Object o : buttonList) {
            GuiButton button = (GuiButton)o;
            this.buttonDecorationTop.draw(button.field_146128_h, button.field_146129_i - this.buttonDecorationTop.h);
            this.buttonDecorationBot.draw(button.field_146128_h, button.field_146129_i + button.field_146121_g);
            this.buttonDecorationTop.draw(button.field_146128_h, button.field_146129_i + button.field_146121_g + this.buttonDecorationTop.h);
        }
        this.panelDecorationL.draw(this.armorInfo.getGuiLeft() + 5, this.armorInfo.getGuiTop() - this.panelDecorationL.h);
        this.panelDecorationR.draw(this.armorInfo.guiRight() - 5 - this.panelDecorationR.w, this.armorInfo.getGuiTop() - this.panelDecorationR.h);
        this.panelDecorationL.draw(this.traitInfo.getGuiLeft() + 5, this.traitInfo.getGuiTop() - this.panelDecorationL.h);
        this.panelDecorationR.draw(this.traitInfo.guiRight() - 5 - this.panelDecorationR.w, this.traitInfo.getGuiTop() - this.panelDecorationR.h);
        GlStateManager.func_179126_j();
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    protected void drawRepairSlotIcons() {
        for (int i = 0; i < this.activeSlots; ++i) {
            this.drawRepairSlotIcon(i);
        }
    }

    protected void drawRepairSlotIcon(int i) {
        GuiElement icon = null;
        Slot slot = this.field_147002_h.func_75139_a(i);
        if (slot.func_75216_d()) {
            return;
        }
        if (i == 0) {
            icon = Icons.ICON_Pickaxe;
        } else if (i == 1) {
            icon = Icons.ICON_Dust;
        } else if (i == 2) {
            icon = Icons.ICON_Lapis;
        } else if (i == 3) {
            icon = Icons.ICON_Ingot;
        } else if (i == 4) {
            icon = Icons.ICON_Gem;
        } else if (i == 5) {
            icon = Icons.ICON_Quartz;
        }
        if (icon != null) {
            this.drawIconEmpty(slot, icon);
        }
    }

    protected void drawIcon(Slot slot, GuiElement element) {
        this.field_146297_k.func_110434_K().func_110577_a(ICONS);
        element.draw(slot.field_75223_e + this.cornerX - 1, slot.field_75221_f + this.cornerY - 1);
    }

    protected void metal() {
        this.armorInfo.metal();
        this.traitInfo.metal();
        this.armorPreview.metal();
        this.buttonDecorationTop = SlotSpaceTop.shift(GuiArmorStation.SlotSpaceTop.w * 2, 0);
        this.buttonDecorationBot = SlotSpaceBottom.shift(GuiArmorStation.SlotSpaceBottom.w * 2, 0);
        this.panelDecorationL = PanelSpaceL.shift(36, 0);
        this.panelDecorationR = PanelSpaceR.shift(36, 0);
        this.buttons.metal();
        this.beamL = BeamLeft.shift(0, GuiArmorStation.BeamLeft.h);
        this.beamR = BeamRight.shift(0, GuiArmorStation.BeamRight.h);
        this.beamC = BeamCenter.shift(0, GuiArmorStation.BeamCenter.h);
    }

    protected void wood() {
        this.armorInfo.wood();
        this.traitInfo.wood();
        this.armorPreview.wood();
        this.buttonDecorationTop = SlotSpaceTop.shift(GuiArmorStation.SlotSpaceTop.w, 0);
        this.buttonDecorationBot = SlotSpaceBottom.shift(GuiArmorStation.SlotSpaceBottom.w, 0);
        this.panelDecorationL = PanelSpaceL.shift(18, 0);
        this.panelDecorationR = PanelSpaceR.shift(18, 0);
        this.buttons.wood();
        this.beamL = BeamLeft;
        this.beamR = BeamRight;
        this.beamC = BeamCenter;
    }

    public void error(String message) {
        this.armorInfo.setCaption(Util.translate((String)"gui.error", (Object[])new Object[0]));
        this.armorInfo.setText(new String[]{message});
        this.traitInfo.setCaption(null);
        this.traitInfo.setText(new String[0]);
    }

    public void warning(String message) {
        this.armorInfo.setCaption(Util.translate((String)"gui.warning", (Object[])new Object[0]));
        this.armorInfo.setText(new String[]{message});
        this.traitInfo.setCaption(null);
        this.traitInfo.setText(new String[0]);
    }

    @SideOnly(value=Side.CLIENT)
    static class AppearanceButton
    extends GuiButton {
        private final boolean forward;

        public AppearanceButton(int buttonID, int x, int y, boolean forward) {
            super(buttonID, x, y, 12, 19, "");
            this.forward = forward;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(BACKGROUND);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = 82;
                int j = 176;
                if (!this.field_146124_l) {
                    j += this.field_146120_f * 2;
                } else if (flag) {
                    j += this.field_146120_f;
                }
                if (!this.forward) {
                    i += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, j, i, this.field_146120_f, this.field_146121_g);
            }
        }
    }
}

