/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.tile;

import elec332.core.api.wrench.IWrenchable;
import elec332.core.tile.AbstractBlock;
import elec332.core.tile.IComparatorOverride;
import elec332.core.tile.IRandomDisplayTickProviderTile;
import elec332.core.tile.IRedstoneHandler;
import elec332.core.tile.TileBase;
import elec332.core.util.BlockStateHelper;
import elec332.core.util.DirectionHelper;
import elec332.core.util.RegistryHelper;
import elec332.core.world.WorldHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTileBase
extends AbstractBlock
implements IWrenchable,
ITileEntityProvider {
    private static final EnumFacing[] HORIZONTAL;
    private static final EnumFacing[] ALL;
    private Class<? extends TileEntity> tileClass;
    private boolean randomDisplayTick;
    private boolean comparatorInputOverride;
    private boolean redstoneHandler;
    public final String blockName;
    public final String modID;

    public BlockTileBase(Material mat, Class<? extends TileEntity> tileClass, String blockName, String modID) {
        this(mat, tileClass, new ResourceLocation(modID.toLowerCase(), blockName.toLowerCase()));
    }

    public BlockTileBase(Material mat, Class<? extends TileEntity> tileClass, ResourceLocation name) {
        super(mat);
        this.func_149752_b(4.5f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setRegistryName(name);
        this.func_149663_c(name.toString().replace(":", ".").toLowerCase());
        this.tileClass = tileClass;
        this.blockName = name.func_110623_a();
        this.modID = name.func_110624_b();
        if (tileClass != null) {
            this.randomDisplayTick = IRandomDisplayTickProviderTile.class.isAssignableFrom(tileClass);
            this.comparatorInputOverride = IComparatorOverride.class.isAssignableFrom(tileClass);
            this.redstoneHandler = IRedstoneHandler.class.isAssignableFrom(tileClass);
        }
    }

    @Deprecated
    public BlockTileBase registerTile() {
        GameRegistry.registerTileEntity(this.tileClass, (String)this.blockName);
        return this;
    }

    public BlockTileBase register() {
        RegistryHelper.register(this);
        return this;
    }

    private boolean hasFacingProperty() {
        return this.func_176194_O().func_177623_d().contains(BlockStateHelper.FACING_NORMAL.getProperty());
    }

    @Override
    @Nonnull
    public IBlockState getBlockStateForPlacementC(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, @Nullable EnumHand hand) {
        if (this.hasFacingProperty()) {
            return this.func_176194_O().func_177621_b().func_177226_a(BlockStateHelper.FACING_NORMAL.getProperty(), (Comparable)DirectionHelper.getFacingOnPlacement(placer));
        }
        return super.getBlockStateForPlacementC(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    @Override
    public boolean onBlockActivatedC(World world, BlockPos pos, EntityPlayer player, EnumHand hand, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).onBlockActivated(state, player, hand, facing, hitX, hitY, hitZ);
        }
        return super.onBlockActivatedC(world, pos, player, hand, state, facing, hitX, hitY, hitZ);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockClicked(playerIn);
        }
        super.func_180649_a(world, pos, playerIn);
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        try {
            return this.createTile(this.tileClass, world, metadata);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected TileEntity createTile(Class<? extends TileEntity> clazz, @Nonnull World world, int metadata) throws Exception {
        return clazz.newInstance();
    }

    @Override
    public ItemStack itemDropped(World world, BlockPos pos) {
        return new ItemStack((Block)this);
    }

    public boolean canBeReplacedByLeaves(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return false;
    }

    @Override
    public boolean onWrenched(World world, BlockPos pos, EnumFacing forgeDirection) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        return tile instanceof TileBase && ((TileBase)tile).onWrenched(forgeDirection);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack stack) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockPlacedBy(entityLiving, stack);
        }
        super.func_180633_a(world, pos, state, entityLiving, stack);
    }

    @Override
    public void neighborChangedC(World world, BlockPos pos, IBlockState state, Block neighbor, BlockPos p_189540_5_) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onNeighborBlockChange(neighbor);
        }
        super.neighborChangedC(world, pos, state, neighbor, p_189540_5_);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onNeighborTileChange(neighbor);
        }
        super.onNeighborChange(world, pos, neighbor);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockAdded();
        }
        super.func_176213_c(world, pos, state);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockRemoved();
        }
        super.func_180663_b(world, pos, state);
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).getLightValue();
        }
        return super.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).getLightOpacity();
        }
        return super.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity tile;
        if (this.randomDisplayTick && (tile = WorldHelper.getTileAt((IBlockAccess)world, pos)) != null) {
            ((IRandomDisplayTickProviderTile)tile).randomDisplayTick(state, rand);
        }
    }

    @Nonnull
    public List<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).getDrops(fortune);
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile;
        if (this.redstoneHandler && (tile = WorldHelper.getTileAt(world, pos)) instanceof IRedstoneHandler) {
            return ((IRedstoneHandler)tile).isProvidingWeakPower(side);
        }
        return super.func_180656_a(state, world, pos, side);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction) {
        TileEntity tile;
        if (this.redstoneHandler && (tile = WorldHelper.getTileAt(world, pos)) instanceof IRedstoneHandler) {
            return ((IRedstoneHandler)tile).canConnectRedstone(direction);
        }
        return super.canConnectRedstone(state, world, pos, direction);
    }

    public boolean func_149740_M(IBlockState state) {
        return this.comparatorInputOverride;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile;
        if (this.comparatorInputOverride && (tile = WorldHelper.getTileAt((IBlockAccess)world, pos)) instanceof IComparatorOverride) {
            return ((IComparatorOverride)tile).getComparatorInputOverride();
        }
        return super.func_180641_l(state, world, pos);
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing sideHit) {
        if (this.hasFacingProperty() && (sideHit != EnumFacing.UP && sideHit != EnumFacing.DOWN || this.canFaceUpOrDown(world, pos))) {
            WorldHelper.setBlockState(world, pos, this.func_176223_P().func_177226_a(BlockStateHelper.FACING_NORMAL.getProperty(), (Comparable)sideHit), 3);
            return true;
        }
        return false;
    }

    public boolean canFaceUpOrDown(World world, BlockPos pos) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        return tile instanceof TileBase && ((TileBase)tile).canFaceUpOrDown();
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return !this.hasFacingProperty() ? state : this.func_176223_P().func_177226_a(BlockStateHelper.FACING_NORMAL.getProperty(), (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b(BlockStateHelper.FACING_NORMAL.getProperty())));
    }

    @Nonnull
    public EnumFacing[] getValidRotations(World world, @Nonnull BlockPos pos) {
        return this.hasFacingProperty() ? (this.canFaceUpOrDown(world, pos) ? ALL : HORIZONTAL) : new EnumFacing[]{};
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return !this.hasFacingProperty() ? state : this.func_176223_P().func_177226_a(BlockStateHelper.FACING_NORMAL.getProperty(), (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(BlockStateHelper.FACING_NORMAL.getProperty())));
    }

    static {
        ALL = EnumFacing.field_82609_l;
        HORIZONTAL = EnumFacing.field_176754_o;
    }
}

