/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import com.google.common.base.Strings;
import elec332.core.main.ElecCore;
import elec332.core.multiblock.IMultiBlock;
import elec332.core.multiblock.IMultiBlockTile;
import elec332.core.multiblock.MultiBlockRegistry;
import elec332.core.util.EnumHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public final class MultiBlockData {
    private final MultiBlockRegistry registry;
    private final IMultiBlockTile tile;
    private IMultiBlock multiBlock = null;
    private EnumFacing mbFacing = null;
    private boolean valid = false;
    private String structureID = "";

    public MultiBlockData(IMultiBlockTile tile, MultiBlockRegistry registry) {
        this.tile = tile;
        this.registry = registry;
    }

    private TileEntity getTileEntity() {
        return (TileEntity)this.tile;
    }

    private World getTileEntityWorld() {
        return this.getTileEntity().func_145831_w();
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        String s = this.mbFacing == null ? "" : EnumHelper.getName(this.mbFacing);
        tagCompound.func_74778_a("facing_MBS", s);
        tagCompound.func_74757_a("valid_MBS", this.valid);
        tagCompound.func_74778_a("structure_MBS", this.structureID);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        String s = tagCompound.func_74779_i("facing_MBS");
        if (!Strings.isNullOrEmpty((String)s)) {
            this.mbFacing = EnumHelper.fromString(s, EnumFacing.class);
        }
        this.valid = tagCompound.func_74767_n("valid_MBS");
        this.structureID = tagCompound.func_74779_i("structure_MBS");
    }

    public void setMultiBlock(IMultiBlock multiBlock, EnumFacing facing, String structureID) {
        this.multiBlock = multiBlock;
        this.mbFacing = facing;
        this.valid = true;
        this.structureID = structureID;
        this.getTileEntity().func_70296_d();
    }

    public void invalidateMultiBlock() {
        this.multiBlock = null;
        this.mbFacing = null;
        this.valid = false;
        this.structureID = "";
        this.getTileEntity().func_70296_d();
    }

    public boolean isValidMultiBlock() {
        return this.valid;
    }

    public String getStructureIdentifier() {
        return this.structureID;
    }

    public EnumFacing getFacing() {
        return this.mbFacing;
    }

    public IMultiBlock getMultiBlock() {
        return this.multiBlock;
    }

    public void tileEntityValidate() {
        ElecCore.tickHandler.registerCall(new Runnable(){

            @Override
            public void run() {
                IMultiBlock.tileEntityValidate(MultiBlockData.this.tile, MultiBlockData.this.multiBlock, MultiBlockData.this.registry);
            }
        }, this.getTileEntityWorld());
    }

    public void tileEntityInvalidate() {
        IMultiBlock.tileEntityInvalidate(this.multiBlock);
    }

    public void tileEntityChunkUnload() {
        IMultiBlock.tileEntityChunkUnload(this.multiBlock, this.tile);
    }
}

