/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.json;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import elec332.core.json.ExtraTypeAdapters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JsonHandler {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().registerTypeAdapterFactory(new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            for (ElecFactory<?> factory : ExtraTypeAdapters.allFactories) {
                Type type = typeToken.getType();
                if (typeToken.getRawType() != factory.getFactoryClass() || factory.hasParameter() && !(type instanceof ParameterizedType)) continue;
                if (factory.hasParameter()) {
                    Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                    TypeAdapter elementAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
                    if (elementAdapter == null) continue;
                    return ((ParameterizedTypeFactory)factory).getTypeAdapter(elementAdapter);
                }
                return factory.getTypeAdapter();
            }
            return null;
        }
    }).create();
    private static final JsonParser parser = new JsonParser();

    public static Gson getGson() {
        return gson;
    }

    public static JsonParser getJsonParser() {
        return parser;
    }

    public static JsonWriter newJsonWriter(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(file));
        jsonWriter.setIndent("  ");
        return jsonWriter;
    }

    public static JsonObject newJsonObject() {
        return new JsonObject();
    }

    public static JsonObject newJsonObject(JsonElement jsonElement, String s) {
        JsonObject jsonObject = JsonHandler.newJsonObject();
        jsonObject.add(s, jsonElement);
        return jsonObject;
    }

    public static JsonObject newJsonObject(JsonEntryData ... data) {
        JsonObject jsonObject = JsonHandler.newJsonObject();
        for (JsonEntryData entryData : data) {
            jsonObject.add(entryData.name, entryData.element);
        }
        return jsonObject;
    }

    public static JsonEntryData newJsonEntry(String identifier, JsonElement jsonElement) {
        return new JsonEntryData(jsonElement, identifier);
    }

    public static JsonObject addToObject(JsonObject main, JsonElement element, String s) {
        main.add(s, element);
        return main;
    }

    public static JsonArray newJsonArray() {
        return new JsonArray();
    }

    public static JsonObject getMainFileObject(File file) throws FileNotFoundException {
        return new JsonParser().parse((Reader)new FileReader(file)).getAsJsonObject();
    }

    public static void toFile(File file, JsonEntryData ... data) {
        JsonHandler.toFile(file, JsonHandler.newJsonObject(data));
    }

    public static void toFile(File file, JsonObject jsonObject) {
        try {
            if (!file.exists()) {
                JsonHandler.createFile(file);
            }
            JsonHandler.toFile(JsonHandler.newJsonWriter(file), jsonObject);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void toFile(JsonWriter writer, JsonEntryData ... data) throws IOException {
        JsonHandler.toFile(writer, JsonHandler.newJsonObject(data));
    }

    public static void toFile(JsonWriter writer, JsonObject jsonObject) throws IOException {
        gson.toJson((JsonElement)jsonObject, writer);
        writer.close();
    }

    public static <T extends Serializable> List<T> getDataAsList(JsonObject jsonObject, String s, Class<T> clazz) {
        ArrayList ret = Lists.newArrayList();
        if (jsonObject.has(s) && jsonObject.get(s).isJsonArray()) {
            for (JsonElement element : (JsonArray)jsonObject.get(s)) {
                ret.add(gson.fromJson(element, clazz));
            }
        }
        return ret;
    }

    public static boolean createFile(File file) {
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static <T extends Serializable> JsonElement toJsonElement(T t, Class<T> clazz) {
        return parser.parse(gson.toJson(t, clazz));
    }

    public static <T extends Serializable> JsonArray toJsonArray(List<T> l, Class<T> clazz) {
        JsonArray jsonArray = JsonHandler.newJsonArray();
        for (Serializable t : l) {
            jsonArray.add(JsonHandler.toJsonElement(t, clazz));
        }
        return jsonArray;
    }

    public static abstract class ParameterizedTypeFactory<E>
    extends ElecFactory<E> {
        public abstract <P> TypeAdapter<E> getTypeAdapter(TypeAdapter<P> var1);

        @Override
        public TypeAdapter<E> getTypeAdapter() {
            throw new IllegalAccessError("ERROR: this should be impossible!");
        }

        @Override
        public final boolean hasParameter() {
            return true;
        }
    }

    public static abstract class ElecFactory<E> {
        public abstract TypeAdapter<E> getTypeAdapter();

        public abstract Class<E> getFactoryClass();

        public boolean hasParameter() {
            return false;
        }
    }

    public static class JsonEntryData {
        private String name;
        private JsonElement element;

        private JsonEntryData(JsonElement element, String name) {
            this.element = element;
            this.name = name;
        }
    }
}

