/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget;

import com.google.common.collect.Lists;
import elec332.core.client.RenderHelper;
import elec332.core.client.util.GuiDraw;
import elec332.core.inventory.IWidgetContainer;
import elec332.core.inventory.tooltip.ToolTip;
import elec332.core.inventory.widget.IWidget;
import elec332.core.inventory.widget.IWidgetListener;
import elec332.core.inventory.window.Window;
import elec332.core.main.ElecCore;
import elec332.core.network.packets.PacketSyncWidget;
import elec332.core.network.packets.PacketWidgetDataToServer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Widget
implements IWidget {
    private IWidgetContainer container;
    private int id;
    public final int x;
    public final int y;
    public final int u;
    public final int v;
    public final int width;
    public final int height;
    private boolean hidden;
    private ResourceLocation background = null;

    public Widget(int x, int y, int u, int v, int width, int height) {
        this.x = x;
        this.y = y;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
    }

    @Override
    public final Widget setContainer(IWidgetContainer container) {
        this.container = container;
        return this;
    }

    @Override
    public final Widget setID(int id) {
        this.id = id;
        return this;
    }

    public Widget setBackground(ResourceLocation background) {
        this.background = background;
        return this;
    }

    @Override
    public void initWidget(IWidgetListener iCrafting) {
        this.detectAndSendChanges(Lists.newArrayList((Object[])new IWidgetListener[]{iCrafting}));
    }

    @Override
    public void detectAndSendChanges(Iterable<IWidgetListener> crafters) {
    }

    public void sendProgressBarUpdate(Iterable<IWidgetListener> crafters, int value) {
        for (IWidgetListener iCrafting : crafters) {
            this.sendProgressBarUpdate(iCrafting, value);
        }
    }

    public void sendProgressBarUpdate(IWidgetListener iCrafting, int value) {
        iCrafting.sendProgressBarUpdate(value);
    }

    @Override
    public void updateProgressbar(int value) {
    }

    public final void sendNBTChangesToPlayer(EntityPlayerMP player, NBTTagCompound tagCompound) {
        ElecCore.networkHandler.sendTo((IMessage)new PacketSyncWidget(tagCompound, this.container, this), player);
    }

    public final void sendNBTChangesToServer(NBTTagCompound tagCompound) {
        ElecCore.networkHandler.sendToServer(new PacketWidgetDataToServer(tagCompound, this.container, this));
    }

    @Override
    public final void readNBTChangesFromPacket(NBTTagCompound tagCompound, Side receiver) {
        if (receiver == Side.CLIENT) {
            this.readNBTChangesFromPacket(tagCompound);
        } else {
            this.readNBTChangesFromPacketServerSide(tagCompound);
        }
    }

    public void readNBTChangesFromPacket(NBTTagCompound tagCompound) {
    }

    public void readNBTChangesFromPacketServerSide(NBTTagCompound tagCompound) {
    }

    @Override
    public final boolean isMouseOver(int mouseX, int mouseY) {
        return this.isMouseOver(mouseX, mouseY, this.x, this.y, this.width, this.height);
    }

    protected final boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return false;
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMouseWheel(int wheel, int translatedMouseX, int translatedMouseY) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(Window window, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.background != null) {
            RenderHelper.bindTexture(this.background);
        }
        GuiDraw.drawTexturedModalRect(guiX + this.x, guiY + this.y, this.u, this.v, this.width, this.height);
    }

    @SideOnly(value=Side.CLIENT)
    protected final void bindTexture(ResourceLocation resourceLocation) {
        RenderHelper.bindTexture(resourceLocation);
    }

    public Widget setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ToolTip getToolTip(int mouseX, int mouseY) {
        return null;
    }
}

