/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid;

import com.google.common.collect.Sets;
import elec332.core.grid.GridInformation;
import elec332.core.grid.IPositionable;
import elec332.core.grid.IStructureWorldEventHandler;
import elec332.core.grid.ITileEntityLink;
import elec332.core.main.ElecCore;
import elec332.core.world.DefaultMultiWorldPositionedObjectHolder;
import elec332.core.world.DimensionCoordinate;
import elec332.core.world.IMultiWorldPositionedObjectHolder;
import elec332.core.world.PositionedObjectHolder;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public abstract class AbstractGridHandler<T extends IPositionable>
implements IStructureWorldEventHandler {
    private final Supplier<IMultiWorldPositionedObjectHolder<T>> objectsInternal = this.getWorldPosObjHolder();
    private final Set<PositionedObjectHolder.ChangeCallback<T>> changeCallbacks;
    protected final Set<DimensionCoordinate> extraUnload;
    protected final Set<DimensionCoordinate> changeCheck;
    protected final Set<DimensionCoordinate> add;
    protected boolean removeWarningOverride = false;

    public AbstractGridHandler() {
        this.objectsInternal.get().addCreateCallback(new Consumer<PositionedObjectHolder<T>>(){

            @Override
            public void accept(PositionedObjectHolder<T> obj) {
                for (PositionedObjectHolder.ChangeCallback callback : AbstractGridHandler.this.changeCallbacks) {
                    obj.registerCallback(callback);
                }
            }
        });
        this.extraUnload = Sets.newHashSet();
        this.changeCheck = Sets.newHashSet();
        this.add = Sets.newHashSet();
        this.changeCallbacks = Sets.newHashSet();
        this.registerChangeCallback(new PositionedObjectHolder.ChangeCallback<T>(){

            @Override
            public void onChange(T objectU, BlockPos pos, boolean add) {
                if (objectU == null) {
                    return;
                }
                if (!(objectU instanceof ITileEntityLink)) {
                    return;
                }
                ITileEntityLink object = (ITileEntityLink)objectU;
                Class type = object.getInformationType();
                if (type == null) {
                    return;
                }
                TileEntity tile = object.getTileEntity();
                if (tile != null) {
                    for (Field field : tile.getClass().getDeclaredFields()) {
                        Object o;
                        Class clazz;
                        if (!field.isAnnotationPresent(GridInformation.class) || (clazz = field.getAnnotation(GridInformation.class).value()) != type) continue;
                        if (!field.getType().isAssignableFrom(type)) {
                            throw new IllegalArgumentException();
                        }
                        Object object2 = o = add ? object.getInformation() : null;
                        if (o != null && !type.isAssignableFrom(o.getClass())) {
                            throw new IllegalArgumentException();
                        }
                        try {
                            field.setAccessible(true);
                            field.set(tile, o);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        });
    }

    protected Supplier<IMultiWorldPositionedObjectHolder<T>> getWorldPosObjHolder() {
        return new DefaultMultiWorldPositionedObjectHolder();
    }

    protected final Map<Integer, PositionedObjectHolder<T>> getObjects() {
        return this.objectsInternal.get().getUnModifiableView();
    }

    @Override
    public void checkNotifyStuff(Set<DimensionCoordinate> updates) {
        for (DimensionCoordinate dimCoord : updates) {
            T o = this.getObject(dimCoord);
            if (o == null) continue;
            TileEntity tile = dimCoord.getTileEntity();
            if (tile == null) {
                if (o != null) {
                    this.extraUnload.add(dimCoord);
                }
                return;
            }
            if (!o.getPosition().isLoaded()) {
                throw new IllegalStateException();
            }
            if (!o.hasChanged()) continue;
            this.changeCheck.add(dimCoord);
            return;
        }
    }

    @Override
    public void checkBlockUpdates(Set<DimensionCoordinate> updates) {
        for (DimensionCoordinate dimCoord : updates) {
            TileEntity tile = dimCoord.isLoaded() ? dimCoord.getTileEntity() : null;
            T o = this.getObject(dimCoord);
            if (o == null && tile == null) continue;
            if (o == null && this.isValidObject(tile)) {
                this.add.add(dimCoord);
            }
            if (o != null && tile == null) {
                this.extraUnload.add(dimCoord);
                continue;
            }
            if (o == null || !this.isValidObject(tile) || !o.hasChanged()) continue;
            this.changeCheck.add(dimCoord);
        }
    }

    @Override
    public void worldUnload(World world) {
        PositionedObjectHolder<T> worldObjects = this.objectsInternal.get().get(world);
        if (worldObjects != null) {
            HashSet unload = Sets.newHashSet();
            for (ChunkPos chunkPos : worldObjects.getChunks()) {
                for (IPositionable o : worldObjects.getObjectsInChunk(chunkPos).values()) {
                    unload.add(o.getPosition());
                }
            }
            this.unloadObjects_Internal(unload);
        }
    }

    @Override
    public void checkChunkUnload(Set<DimensionCoordinate> updates) {
        updates.addAll(this.extraUnload);
        updates.addAll(this.changeCheck);
        this.unloadObjects_Internal(updates);
        this.extraUnload.clear();
    }

    protected void unloadObjects_Internal(Set<DimensionCoordinate> updates) {
        Set<DimensionCoordinate> updates_ = Collections.unmodifiableSet(updates);
        for (DimensionCoordinate dimCoord : updates) {
            T o = this.getObject(dimCoord);
            if (o == null) {
                System.out.println("????_-3");
                continue;
            }
            this.onObjectRemoved(o, updates_);
            this.removeObject(dimCoord);
        }
    }

    protected abstract void onObjectRemoved(T var1, Set<DimensionCoordinate> var2);

    @Override
    public void checkChunkLoad(Set<DimensionCoordinate> updates) {
        HashSet oldUpdates = Sets.newHashSet(updates);
        updates.addAll(this.add);
        updates.addAll(this.changeCheck);
        for (DimensionCoordinate dimCoord : updates) {
            TileEntity tile = dimCoord.getTileEntity();
            if (tile == null || !this.isValidObject(tile)) continue;
            T o = this.getObject(dimCoord);
            if (o != null) {
                if (oldUpdates.contains(dimCoord) && !ElecCore.suppressSpongeIssues && !this.removeWarningOverride) {
                    throw new IllegalStateException();
                }
            } else {
                o = this.createNewObject(tile);
                this.objectsInternal.get().get(tile.func_145831_w()).put(o, tile.func_174877_v());
                o.hasChanged();
            }
            this.internalAdd(o);
        }
        this.add.clear();
        this.changeCheck.clear();
    }

    protected abstract void internalAdd(T var1);

    @Override
    public abstract void tick();

    @Override
    public abstract boolean isValidObject(TileEntity var1);

    protected abstract T createNewObject(TileEntity var1);

    protected void removeObject(DimensionCoordinate dimensionCoordinate) {
        this.getDim(dimensionCoordinate).remove(dimensionCoordinate.getPos());
    }

    protected T getObject(DimensionCoordinate dimensionCoordinate) {
        return (T)((IPositionable)this.getDim(dimensionCoordinate).get(dimensionCoordinate.getPos()));
    }

    protected PositionedObjectHolder<T> getDim(DimensionCoordinate dimensionCoordinate) {
        return this.objectsInternal.get().getOrCreate(dimensionCoordinate.getDimension());
    }

    public void registerChangeCallback(PositionedObjectHolder.ChangeCallback<T> callback) {
        if (this.changeCallbacks.add(callback)) {
            for (PositionedObjectHolder<T> o : this.objectsInternal.get().getValues()) {
                o.registerCallback(callback);
            }
        }
    }
}

