/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.loading;

import com.google.common.collect.Lists;
import elec332.core.client.model.loading.IBlockModelItemLink;
import elec332.core.util.BlockStateHelper;
import elec332.core.util.DirectionHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface INoBlockStateJsonBlock
extends IBlockModelItemLink {
    @SideOnly(value=Side.CLIENT)
    public VariantList getVariantsFor(IBlockState var1);

    default public boolean hasTextureOverrideJson(IBlockState state) {
        return true;
    }

    default public ResourceLocation getTextureOverridesJson(IBlockState state, Variant variant) {
        return new ResourceLocation(variant.func_188046_a().toString() + "_overrides");
    }

    default public void addAdditionalData(IBlockState state, Map<String, String> dataMap) {
    }

    public static interface DefaultImpl
    extends INoBlockStateJsonBlock {
        @Override
        default public VariantList getVariantsFor(IBlockState state) {
            return new VariantList((List)Lists.newArrayList((Object[])new Variant[]{new Variant(state.func_177230_c().getRegistryName(), ModelRotation.X0_Y0, false, 0)}));
        }
    }

    public static interface RotationImpl
    extends INoBlockStateJsonBlock {
        @Override
        @SideOnly(value=Side.CLIENT)
        default public VariantList getVariantsFor(IBlockState state) {
            Block b = state.func_177230_c();
            ModelRotation mr = DirectionHelper.getRotationFromFacing((EnumFacing)state.func_177229_b(BlockStateHelper.FACING_NORMAL.getProperty()));
            Variant variant = new Variant(b.getRegistryName(), mr, false, 1);
            return new VariantList((List)Lists.newArrayList((Object[])new Variant[]{variant}));
        }
    }
}

