/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.asm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMHelper {
    private static final boolean isObfuscated = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") == false;

    public static String getClassName(String deobf) {
        if (isObfuscated) {
            return FMLDeobfuscatingRemapper.INSTANCE.unmap(deobf.replace('.', '/')).replace('/', '.');
        }
        return deobf;
    }

    public static String getDescription(String deobf) {
        if (isObfuscated) {
            Matcher classNameMatcher = Pattern.compile("L([^;]+);").matcher(deobf);
            StringBuffer obfDescBuffer = new StringBuffer(deobf.length());
            while (classNameMatcher.find()) {
                classNameMatcher.appendReplacement(obfDescBuffer, ASMHelper.getDescriptor(classNameMatcher.group(1).replace('/', '.')));
            }
            classNameMatcher.appendTail(obfDescBuffer);
            return obfDescBuffer.toString();
        }
        return deobf;
    }

    public static String getDescriptor(String deobfClass) {
        return "L" + ASMHelper.getClassName(deobfClass).replace('.', '/') + ";";
    }

    public static String getInternalName(Class clazz) {
        return Type.getInternalName((Class)clazz);
    }

    public static AbstractInsnNode removeInsnNodes(InsnList insnList, AbstractInsnNode start, int amount) {
        AbstractInsnNode n = start;
        for (int i = 0; i < amount; ++i) {
            n = n.getNext();
            insnList.remove(n.getPrevious());
        }
        return n;
    }

    @Nullable
    public static LineNumberNode removeInsnUntilNextLabel(InsnList insnList, AbstractInsnNode from) {
        LineNumberNode to = ASMHelper.findFirstLineAfter(from);
        if (to != null) {
            return ASMHelper.removeInsnUntil(insnList, from, to.line);
        }
        throw new RuntimeException();
    }

    @Nullable
    public static LineNumberNode removeInsnUntil(InsnList insnList, AbstractInsnNode from, int untilLine) {
        AbstractInsnNode nxt = from;
        while (!ASMHelper.isLine(nxt, untilLine) && !ASMHelper.isLine(nxt.getNext(), untilLine)) {
            nxt = nxt.getNext();
            insnList.remove(nxt.getPrevious());
        }
        return (LineNumberNode)nxt.getNext();
    }

    @Nonnull
    public static MethodNode getConstructorNode(ClassNode classNode) {
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals("<init>")) continue;
            return mn;
        }
        throw new RuntimeException("Class " + classNode.name + " has no constructor?!?");
    }

    @Nullable
    public static LabelNode findLabel(InsnList insnList, int line) {
        return ASMHelper.findLabelAfter(insnList.get(0), line);
    }

    @Nullable
    public static LabelNode findLabelAfter(AbstractInsnNode from, int line) {
        AbstractInsnNode gt = from.getNext();
        while (!ASMHelper.isLine(gt, line)) {
            if (gt == null) {
                return null;
            }
            gt = gt.getNext();
        }
        return ((LineNumberNode)gt).start;
    }

    @Nullable
    public static LineNumberNode findFirstLineAfter(AbstractInsnNode node) {
        AbstractInsnNode nxt = node.getNext();
        while (!ASMHelper.isType(nxt, 15)) {
            if (nxt == null) {
                return null;
            }
            nxt = nxt.getNext();
        }
        return (LineNumberNode)nxt;
    }

    public static boolean isLine(AbstractInsnNode node, int line) {
        return ASMHelper.isType(node, 15) && ((LineNumberNode)node).line == line;
    }

    public static boolean isType(AbstractInsnNode node, int type) {
        return node != null && node.getType() == type;
    }
}

