/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.api.util;

import net.minecraft.util.math.BlockPos;

public class Area {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public Area(BlockPos pos1, BlockPos pos2) {
        this(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    public Area(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public short getWidth() {
        return (short)(this.maxX - this.minX);
    }

    public short getHeight() {
        return (short)(this.maxY - this.minY);
    }

    public short getLength() {
        return (short)(this.maxZ - this.minZ);
    }

    public short getBlockWidth() {
        return (short)(this.getWidth() + 1);
    }

    public short getBlockHeight() {
        return (short)(this.getHeight() + 1);
    }

    public short getBlockLength() {
        return (short)(this.getLength() + 1);
    }

    public int getBlockCount() {
        return this.getBlockWidth() * this.getBlockHeight() * this.getBlockLength();
    }

    public Area offset(BlockPos pos) {
        return this.offset(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Area offset(int x, int y, int z) {
        return new Area(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public boolean doAreasIntersect(Area otherArea) {
        return this.intersects(otherArea.minX, otherArea.minY, otherArea.minZ, otherArea.maxX, otherArea.maxY, otherArea.maxZ);
    }

    public boolean intersects(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (double)this.minX < Math.max(x1, x2) && (double)this.maxX > Math.min(x1, x2) && (double)this.minY < Math.max(y1, y2) && (double)this.maxY > Math.min(y1, y2) && (double)this.minZ < Math.max(z1, z2) && (double)this.maxZ > Math.min(z1, z2);
    }

    public String toString() {
        return "Area{x1=" + this.minX + ", y1=" + this.minY + ", z1=" + this.minZ + ", x2=" + this.maxX + ", y2=" + this.maxY + ", z2=" + this.maxZ + '}';
    }
}

