/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.abstraction.abstracted;

import elec332.core.api.annotations.CopyMarker;
import elec332.core.util.ASMHelper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class AbstractClassModifier
implements ASMHelper.IClassModifier {
    public void copyMethodsFrom(String internalClassName, ClassWriter cw, Class<?> copyFrom, IMethodModifier modifier) {
        try {
            ClassReader cr = ASMHelper.getClassReaderFrom(copyFrom);
            ClassNode cv = new ClassNode();
            cr.accept((ClassVisitor)cv, 0);
            block2: for (MethodNode mn : cv.methods) {
                if (mn.visibleAnnotations == null) continue;
                for (AnnotationNode an : mn.visibleAnnotations) {
                    if (!an.desc.equals(Type.getDescriptor(CopyMarker.class))) continue;
                    if (modifier != null) {
                        modifier.modifyMethod(internalClassName, mn);
                    }
                    mn.accept((ClassVisitor)cw);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void copyFieldsFrom(String internalClassName, ClassWriter cw, Class<?> copyFrom, IFieldModifier modifier) {
        try {
            ClassReader cr = ASMHelper.getClassReaderFrom(copyFrom);
            ClassNode cv = new ClassNode();
            cr.accept((ClassVisitor)cv, 0);
            block2: for (FieldNode fn : cv.fields) {
                if (fn.visibleAnnotations == null) continue;
                for (AnnotationNode an : fn.visibleAnnotations) {
                    if (!an.desc.equals(Type.getDescriptor(CopyMarker.class))) continue;
                    if (modifier != null) {
                        modifier.modifyField(internalClassName, fn);
                    }
                    fn.accept((ClassVisitor)cw);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class MethodFixer
    implements IMethodModifier {
        private final Class<?> original;

        public MethodFixer(Class<?> original) {
            this.original = original;
        }

        @Override
        public void modifyMethod(String internalClassName, MethodNode mn) {
            InsnList ins = mn.instructions;
            for (int i = 0; i < ins.size(); ++i) {
                AbstractInsnNode nxt;
                AbstractInsnNode ain = ins.get(i);
                if (ain.getType() == 5 && ((MethodInsnNode)ain).owner.equals(Type.getInternalName(this.original))) {
                    MethodInsnNode min = (MethodInsnNode)ain;
                    nxt = ain.getNext();
                    ins.remove(ain);
                    ins.insertBefore(nxt, (AbstractInsnNode)new MethodInsnNode(min.getOpcode(), internalClassName, min.name, min.desc, min.itf));
                    continue;
                }
                if (ain.getType() != 4 || !((FieldInsnNode)ain).owner.equals(Type.getInternalName(this.original))) continue;
                FieldInsnNode fin = (FieldInsnNode)ain;
                nxt = ain.getNext();
                ins.remove(ain);
                ins.insertBefore(nxt, (AbstractInsnNode)new FieldInsnNode(fin.getOpcode(), internalClassName, fin.name, fin.desc));
            }
            for (LocalVariableNode lvn : mn.localVariables) {
                if (!lvn.name.equals("this")) continue;
                lvn.desc = "L" + internalClassName + ";";
            }
        }
    }

    public static interface IFieldModifier {
        public void modifyField(String var1, FieldNode var2);
    }

    public static interface IMethodModifier {
        public void modifyMethod(String var1, MethodNode var2);

        public static IMethodModifier combine(final IMethodModifier ... modifiers) {
            if (modifiers == null || modifiers.length == 0) {
                return null;
            }
            return new IMethodModifier(){

                @Override
                public void modifyMethod(String internalClassName, MethodNode mn) {
                    for (IMethodModifier modifier : modifiers) {
                        if (modifier == null) continue;
                        modifier.modifyMethod(internalClassName, mn);
                    }
                }
            };
        }
    }
}

