/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.IObservableFluidTank;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.Validators;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ConcreteFluidTank
extends FluidTank
implements IObservableFluidTank {
    private final List<Runnable> listeners = Lists.newArrayList();
    private Predicate<FluidStack> fillValidator = Validators.ANY_FLUID;

    public ConcreteFluidTank(int capacity) {
        this(null, capacity);
    }

    public ConcreteFluidTank(Fluid fluid, int amount, int capacity) {
        this(new FluidStack(fluid, amount), capacity);
    }

    public ConcreteFluidTank(@Nullable FluidStack fluidStack, int capacity) {
        super(fluidStack, capacity);
    }

    public final ConcreteFluidTank withFillValidator(Predicate<FluidStack> fillValidator) {
        this.fillValidator = fillValidator;
        return this;
    }

    public void markDirty() {
        this.listeners.forEach(Runnable::run);
    }

    @Override
    public void listen(@Nonnull Runnable r) {
        this.listeners.add(r);
    }

    protected void onContentsChanged() {
        this.markDirty();
        super.onContentsChanged();
    }

    @Nonnull
    public Predicate<FluidStack> getFillValidator() {
        return this.fillValidator;
    }
}

