/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.tile;

import com.elytradev.architecture.common.block.BlockHelper;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Utils;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.item.ItemCladding;
import com.elytradev.architecture.common.shape.Shape;
import com.elytradev.architecture.common.tile.TileArchitecture;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileShape
extends TileArchitecture {
    public Shape shape;
    public IBlockState baseBlockState;
    public IBlockState secondaryBlockState;
    public int disabledConnections;
    private byte offsetX;

    public TileShape() {
        this.shape = Shape.ROOF_TILE;
        this.baseBlockState = Blocks.field_150344_f.func_176223_P();
    }

    public TileShape(Shape s, IBlockState b) {
        this.shape = s;
        this.baseBlockState = b;
    }

    public TileShape(Shape s, Block b, int d) {
        this.shape = s;
        this.baseBlockState = b.func_176203_a(d);
    }

    public static TileShape get(IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if (world != null && (te = world.func_175625_s(pos)) instanceof TileShape) {
            return (TileShape)te;
        }
        return null;
    }

    public double getOffsetX() {
        return (double)this.offsetX * 0.0625;
    }

    public void setOffsetX(double value) {
        this.offsetX = (byte)(16.0 * value);
    }

    @Override
    public Trans3 localToGlobalTransformation(Vector3 origin) {
        return super.localToGlobalTransformation(origin).translate(this.getOffsetX(), 0.0, 0.0);
    }

    @Override
    public void onAddedToWorld() {
    }

    public boolean connectionIsEnabledGlobal(EnumFacing dir) {
        return (this.disabledConnections & 1 << dir.ordinal()) == 0;
    }

    public void setConnectionEnabledGlobal(EnumFacing dir, boolean state) {
        int bit = 1 << dir.ordinal();
        this.disabledConnections = state ? (this.disabledConnections &= ~bit) : (this.disabledConnections |= bit);
        this.markBlockChanged();
    }

    public void toggleConnectionGlobal(EnumFacing dir) {
        boolean newState = !this.connectionIsEnabledGlobal(dir);
        this.setConnectionEnabledGlobal(dir, newState);
        TileShape nte = this.getNeighbourGlobal(dir);
        if (nte != null) {
            nte.setConnectionEnabledGlobal(dir.func_176734_d(), newState);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readShapeFromNBT(nbt);
        this.readSecondaryMaterialFromNBT(nbt);
        this.offsetX = nbt.func_74771_c("offsetX");
    }

    @Override
    public void readFromItemStackNBT(NBTTagCompound nbt) {
        this.readShapeFromNBT(nbt);
    }

    protected void readShapeFromNBT(NBTTagCompound nbt) {
        this.shape = Shape.forId(nbt.func_74762_e("Shape"));
        this.baseBlockState = this.nbtGetBlockState(nbt, "BaseName", "BaseData");
        if (this.baseBlockState == null) {
            this.baseBlockState = Blocks.field_150344_f.func_176223_P();
        }
        this.disabledConnections = nbt.func_74762_e("Disconnected");
    }

    protected void readSecondaryMaterialFromNBT(NBTTagCompound nbt) {
        this.secondaryBlockState = this.nbtGetBlockState(nbt, "Name2", "Data2");
    }

    protected IBlockState nbtGetBlockState(NBTTagCompound nbt, String nameField, String dataField) {
        String blockName = nbt.func_74779_i(nameField);
        if (blockName != null && blockName.length() > 0) {
            Block block = Block.func_149684_b((String)blockName);
            int data = nbt.func_74762_e(dataField);
            IBlockState state = block.func_176203_a(data);
            return state;
        }
        return null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeShapeToNBT(nbt);
        this.writeSecondaryMaterialToNBT(nbt);
        if (this.offsetX != 0) {
            nbt.func_74774_a("offsetX", this.offsetX);
        }
        return nbt;
    }

    @Override
    public void writeToItemStackNBT(NBTTagCompound nbt) {
        this.writeShapeToNBT(nbt);
    }

    protected void writeShapeToNBT(NBTTagCompound nbt) {
        if (this.shape != null) {
            nbt.func_74768_a("Shape", this.shape.id);
            this.nbtSetBlockState(nbt, "BaseName", "BaseData", this.baseBlockState);
        }
        if (this.disabledConnections != 0) {
            nbt.func_74768_a("Disconnected", this.disabledConnections);
        }
    }

    protected void writeSecondaryMaterialToNBT(NBTTagCompound nbt) {
        this.nbtSetBlockState(nbt, "Name2", "Data2", this.secondaryBlockState);
    }

    protected void nbtSetBlockState(NBTTagCompound nbt, String nameField, String dataField, IBlockState state) {
        if (state != null) {
            Block block = state.func_177230_c();
            nbt.func_74778_a(nameField, BlockHelper.getNameForBlock(block));
            nbt.func_74768_a(dataField, block.func_176201_c(state));
        }
    }

    public void onChiselUse(EntityPlayer player, EnumFacing face, float hitX, float hitY, float hitZ) {
        this.shape.kind.onChiselUse(this, player, face, this.hitVec(hitX, hitY, hitZ));
    }

    public void onHammerUse(EntityPlayer player, EnumFacing face, float hitX, float hitY, float hitZ) {
        this.shape.kind.onHammerUse(this, player, face, this.hitVec(hitX, hitY, hitZ));
    }

    protected Vector3 hitVec(float hitX, float hitY, float hitZ) {
        return new Vector3((double)hitX - 0.5, (double)hitY - 0.5, (double)hitZ - 0.5);
    }

    public EnumFacing globalFace(EnumFacing face) {
        return this.localToGlobalRotation().t(face);
    }

    public EnumFacing localFace(EnumFacing face) {
        return this.localToGlobalRotation().it(face);
    }

    public boolean applySecondaryMaterial(ItemStack stack, EntityPlayer player) {
        IBlockState materialState = null;
        Item item = stack.func_77973_b();
        if (item instanceof ItemCladding && this.shape.kind.acceptsCladding()) {
            materialState = ((ItemCladding)item).blockStateFromStack(stack);
        } else {
            IBlockState state;
            Block block = Block.func_149634_a((Item)item);
            if (block != null && this.shape.kind.isValidSecondaryMaterial(state = block.func_176203_a(stack.func_77960_j()))) {
                materialState = state;
            }
        }
        if (materialState != null) {
            if (this.secondaryBlockState == null) {
                this.setSecondaryMaterial(materialState);
                if (!Utils.playerIsInCreativeMode(player)) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    public void setSecondaryMaterial(IBlockState state) {
        this.secondaryBlockState = state;
        this.markBlockChanged();
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (this.baseBlockState.func_177230_c().canRenderInLayer(state, layer)) {
            return true;
        }
        if (this.secondaryBlockState != null) {
            return this.secondaryBlockState.func_177230_c().canRenderInLayer(state, layer);
        }
        return false;
    }

    public TileShape getNeighbourGlobal(EnumFacing dir) {
        return TileShape.get((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(dir));
    }

    public TileShape getConnectedNeighbourGlobal(EnumFacing dir) {
        TileShape nte;
        if (this.field_145850_b != null && this.connectionIsEnabledGlobal(dir) && (nte = this.getNeighbourGlobal(dir)) != null && nte.connectionIsEnabledGlobal(dir.func_176734_d())) {
            return nte;
        }
        return null;
    }
}

