/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.block;

import com.elytradev.architecture.common.block.BlockArchitecture;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.tile.TileShape;
import com.elytradev.architecture.legacy.base.BaseOrientation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShape
extends BlockArchitecture<TileShape> {
    public static IProperty<Integer> LIGHT = PropertyInteger.func_177719_a((String)"light", (int)0, (int)15);
    protected AxisAlignedBB boxHit;

    public BlockShape() {
        super(Material.field_151578_c, TileShape.class);
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        if (state instanceof IExtendedBlockState) {
            TileShape shape;
            IBlockAccess world = (IBlockAccess)((IExtendedBlockState)state).getValue(BLOCKACCESS_PROP);
            BlockPos pos = (BlockPos)((IExtendedBlockState)state).getValue(POS_PROP);
            if (world != null && pos != null && (shape = TileShape.get(world, pos)) != null) {
                return shape.baseBlockState.func_177230_c().getHarvestTool(shape.baseBlockState);
            }
        }
        return super.getHarvestTool(state);
    }

    public int getHarvestLevel(IBlockState state) {
        if (state instanceof IExtendedBlockState) {
            TileShape shape;
            IBlockAccess world = (IBlockAccess)((IExtendedBlockState)state).getValue(BLOCKACCESS_PROP);
            BlockPos pos = (BlockPos)((IExtendedBlockState)state).getValue(POS_PROP);
            if (world != null && pos != null && (shape = TileShape.get(world, pos)) != null) {
                return shape.baseBlockState.func_177230_c().getHarvestLevel(shape.baseBlockState);
            }
        }
        return super.getHarvestLevel(state);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        TileShape shape = TileShape.get((IBlockAccess)worldIn, pos);
        if (shape != null && shape.baseBlockState != null) {
            return shape.baseBlockState.func_185887_b(worldIn, pos);
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public static float acBlockStrength(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        float hardness = 2.0f;
        try {
            hardness = state.func_185887_b(world, pos);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (hardness < 0.0f) {
            return 0.0f;
        }
        float strength = player.getDigSpeed(state, pos) / hardness;
        if (!BlockShape.acCanHarvestBlock(state, player)) {
            return strength / 100.0f;
        }
        return strength / 30.0f;
    }

    public static boolean acCanHarvestBlock(IBlockState state, EntityPlayer player) {
        Block block = state.func_177230_c();
        if (block.func_149688_o(state).func_76229_l()) {
            return true;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        String tool = block.getHarvestTool(state);
        if (stack == null || tool == null) {
            return player.func_184823_b(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    @Override
    protected void defineProperties() {
        super.defineProperties();
        this.addProperty(LIGHT);
    }

    @Override
    public int getNumSubtypes() {
        return 16;
    }

    @Override
    public BlockArchitecture.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient24WaysByTE;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult result = null;
        double nearestDistance = 0.0;
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, pos, state, null);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AxisAlignedBB box = list.get(i);
                RayTraceResult mp = box.func_72327_a(start, end);
                if (mp == null) continue;
                mp.subHit = i;
                double d = start.func_72436_e(mp.field_72307_f);
                if (result != null && !(d < nearestDistance)) continue;
                result = mp;
                nearestDistance = d;
            }
        }
        if (result != null) {
            int i = result.subHit;
            this.boxHit = list.get(i).func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            result = new RayTraceResult(result.field_72307_f, result.field_178784_b, pos);
            result.subHit = i;
        }
        return result;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileShape te;
        if (this.boxHit != null && (te = TileShape.get(world, pos)) != null && te.shape.kind.highlightZones()) {
            return this.boxHit;
        }
        AxisAlignedBB box = this.getLocalBounds(world, pos, state, null);
        if (box != null) {
            return box;
        }
        return super.func_185496_a(state, world, pos);
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB clip, List result, Entity entity, boolean b) {
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, pos, state, entity);
        if (list != null) {
            for (AxisAlignedBB box : list) {
                if (!clip.func_72326_a(box)) continue;
                result.add(box);
            }
        }
    }

    @Override
    protected List<AxisAlignedBB> getGlobalCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        TileShape te = (TileShape)((Object)this.getTileEntity(world, pos));
        if (te != null) {
            Trans3 t = te.localToGlobalTransformation();
            return this.getCollisionBoxes(te, world, pos, state, t, entity);
        }
        return new ArrayList<AxisAlignedBB>();
    }

    @Override
    protected List<AxisAlignedBB> getLocalCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        TileShape te = (TileShape)((Object)this.getTileEntity(world, pos));
        if (te != null) {
            Trans3 t = te.localToGlobalTransformation(Vector3.zero);
            return this.getCollisionBoxes(te, world, pos, state, t, entity);
        }
        return new ArrayList<AxisAlignedBB>();
    }

    @Override
    protected AxisAlignedBB getLocalBounds(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        TileShape te = (TileShape)((Object)this.getTileEntity(world, pos));
        if (te != null) {
            Trans3 t = te.localToGlobalTransformation(Vector3.blockCenter);
            return te.shape.kind.getBounds(te, world, pos, state, entity, t);
        }
        return null;
    }

    protected List<AxisAlignedBB> getCollisionBoxes(TileShape te, IBlockAccess world, BlockPos pos, IBlockState state, Trans3 t, Entity entity) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        te.shape.kind.addCollisionBoxesToList(te, world, pos, state, entity, t, list);
        return list;
    }

    @Override
    protected List<ItemStack> getDropsFromTileEntity(IBlockAccess world, BlockPos pos, IBlockState state, TileEntity te, int fortune) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (te instanceof TileShape) {
            TileShape ste = (TileShape)te;
            ItemStack stack = ste.shape.kind.newStack(ste.shape, ste.baseBlockState, 1);
            result.add(stack);
            if (ste.secondaryBlockState != null) {
                stack = ste.shape.kind.newSecondaryMaterialStack(ste.secondaryBlockState);
                result.add(stack);
            }
        }
        return result;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileShape te = TileShape.get((IBlockAccess)world, pos);
        if (te != null) {
            return te.newItemStack(1);
        }
        return ItemStack.field_190927_a;
    }

    public IBlockState getBaseBlockState(IBlockAccess world, BlockPos pos) {
        TileShape te = (TileShape)((Object)this.getTileEntity(world, pos));
        if (te != null) {
            return te.baseBlockState;
        }
        return null;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        float result = 1.0f;
        IBlockState base = this.getBaseBlockState((IBlockAccess)world, pos);
        if (base != null) {
            result = BlockShape.acBlockStrength(base, player, world, pos);
        }
        return result;
    }

    @Override
    public IBlockState getParticleState(IBlockAccess world, BlockPos pos) {
        IBlockState base = this.getBaseBlockState(world, pos);
        if (base != null) {
            return base;
        }
        return this.func_176223_P();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileShape te;
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && (te = TileShape.get((IBlockAccess)world, pos)) != null) {
            return te.applySecondaryMaterial(stack, player);
        }
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        return 0.8f;
    }

    public int func_149750_m(IBlockState state) {
        return (Integer)state.func_177229_b(LIGHT);
    }
}

