/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.client.render.shape;

import com.elytradev.architecture.client.render.ICustomRenderer;
import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.client.render.texture.TextureBase;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Utils;
import com.elytradev.architecture.common.tile.TileShape;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ShapeRenderDispatch
implements ICustomRenderer {
    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, RenderTargetBase target, BlockRenderLayer layer, Trans3 t) {
        TileShape te = TileShape.get(world, pos);
        if (te != null) {
            Trans3 t2 = t.t(te.localToGlobalRotation());
            boolean renderBase = this.canRenderInLayer(te.baseBlockState, layer);
            boolean renderSecondary = this.canRenderInLayer(te.secondaryBlockState, layer);
            int baseColour = renderBase ? this.getColourFromState(te.baseBlockState) : -1;
            int secondaryColour = renderSecondary ? this.getColourFromState(te.secondaryBlockState) : baseColour;
            this.renderShapeTE(te, target, t2, renderBase, renderSecondary, baseColour, secondaryColour);
        }
    }

    protected boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (layer == null) {
            return true;
        }
        return state != null && state.func_177230_c().canRenderInLayer(state, layer);
    }

    @Override
    public void renderItemStack(ItemStack stack, RenderTargetBase target, Trans3 t) {
        TileShape te = new TileShape();
        te.readFromItemStack(stack);
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        ItemStack baseStack = this.getStackFromState(te.baseBlockState);
        ItemStack secondaryStack = this.getStackFromState(te.secondaryBlockState);
        int baseColour = baseStack != null ? itemColors.func_186728_a(baseStack, 0) : -1;
        int secondaryColour = secondaryStack != null ? itemColors.func_186728_a(secondaryStack, 0) : baseColour;
        this.renderShapeTE(te, target, t, te.baseBlockState != null, te.secondaryBlockState != null, baseColour, secondaryColour);
    }

    @Nullable
    private ItemStack getStackFromState(IBlockState state) {
        if (state != null && Item.func_150898_a((Block)state.func_177230_c()) != null) {
            Item itemFromBlock = Item.func_150898_a((Block)state.func_177230_c());
            ItemStack defaultInstance = itemFromBlock.func_190903_i();
            defaultInstance.func_77964_b(state.func_177230_c().func_180651_a(state));
            return defaultInstance;
        }
        return null;
    }

    protected void renderShapeTE(TileShape te, RenderTargetBase target, Trans3 t, boolean renderBase, boolean renderSecondary, int baseColourMult, int secondaryColourMult) {
        IBlockState base;
        if (te.shape != null && (renderBase || renderSecondary) && (base = te.baseBlockState) != null) {
            TextureAtlasSprite baseSprite = Utils.getSpriteForBlockState(base);
            TextureAtlasSprite secondarySprite = Utils.getSpriteForBlockState(te.secondaryBlockState);
            if (baseSprite != null) {
                ITexture[] textures = new ITexture[4];
                if (renderBase) {
                    textures[0] = TextureBase.fromSprite(baseSprite);
                    textures[1] = textures[0].projected();
                }
                if (renderSecondary) {
                    if (secondarySprite != null) {
                        textures[2] = TextureBase.fromSprite(secondarySprite);
                        textures[3] = textures[2].projected();
                    } else {
                        renderSecondary = false;
                    }
                }
                if (renderBase && te.shape.kind.secondaryDefaultsToBase() && (secondarySprite == null || te.secondaryBlockState != null && te.secondaryBlockState.func_177230_c().func_180664_k() != BlockRenderLayer.SOLID)) {
                    textures[2] = textures[0];
                    textures[3] = textures[1];
                    renderSecondary = renderBase;
                }
                te.shape.kind.renderShape(te, textures, target, t, renderBase, renderSecondary, baseColourMult, secondaryColourMult);
            }
        }
    }

    private int getColourFromState(IBlockState state) {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        int color = blockColors.func_186724_a(state, null, null, 0);
        return color;
    }

    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, RenderTargetBase target, BlockRenderLayer layer, Trans3 t, boolean renderBase, boolean renderSecondary) {
        if (TileShape.get(world, pos) != null) {
            TileShape te = TileShape.get(world, pos);
            Trans3 t2 = t.t(te.localToGlobalRotation());
            int baseColour = renderBase ? this.getColourFromState(te.baseBlockState) : -1;
            int secondaryColour = renderSecondary ? this.getColourFromState(te.secondaryBlockState) : baseColour;
            this.renderShapeTE(TileShape.get(world, pos), target, t2, renderBase, renderSecondary, baseColour, secondaryColour);
        }
    }
}

