/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;

public class SyncableList {
    private ArrayList<ISyncPart> syncParts = new ArrayList();
    private ArrayList<ISyncPart> changedSyncParts = new ArrayList();
    private ArrayList<IDirtyPart> dirtyParts = new ArrayList();
    private ArrayList<IDirtyPart> changedDirtyParts = new ArrayList();
    public ISyncableListener listener;

    public SyncableList(ISyncableListener listener) {
        this.listener = listener;
    }

    public void addPart(IDirtyPart part) {
        ArrayList<IDirtyPart> changeList;
        ArrayList<IDirtyPart> list = part instanceof ISyncPart ? this.syncParts : this.dirtyParts;
        ArrayList<IDirtyPart> arrayList = changeList = part instanceof ISyncPart ? this.changedSyncParts : this.changedDirtyParts;
        if (!list.contains(part)) {
            list.add(part);
            changeList.add((ISyncPart)part);
            part.setListener(this.listener);
        }
    }

    public void removePart(IDirtyPart part) {
        ArrayList<IDirtyPart> list = part instanceof ISyncPart ? this.syncParts : this.dirtyParts;
        list.remove(part);
    }

    public void addParts(Collection<? extends IDirtyPart> parts) {
        parts.forEach(this::addPart);
    }

    public void addParts(IDirtyPart ... parts) {
        for (IDirtyPart part : parts) {
            this.addPart(part);
        }
    }

    public void markSyncPartChanged(IDirtyPart part) {
        ArrayList<IDirtyPart> list = part instanceof ISyncPart ? this.changedSyncParts : this.changedDirtyParts;
        list.add((ISyncPart)part);
    }

    public void onPartSynced(IDirtyPart part) {
    }

    public void onPartsSynced() {
        this.changedSyncParts.clear();
        this.changedDirtyParts.clear();
    }

    public ArrayList<ISyncPart> getSyncList(NBTHelper.SyncType type) {
        return type.mustSync() ? this.syncParts : this.changedSyncParts;
    }

    public ArrayList<ISyncPart> getStandardSyncParts() {
        return this.syncParts;
    }

    public void copyFrom(SyncableList list) {
        NBTTagCompound copy = new NBTTagCompound();
        NBTHelper.writeSyncParts(copy, NBTHelper.SyncType.SAVE, list, true);
        NBTHelper.readSyncParts(copy, NBTHelper.SyncType.SAVE, this);
    }
}

