/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;

public abstract class SyncTagType<T>
extends SyncPart {
    public T current;
    private int nbtType = -1;

    public SyncTagType(int nbtType, int id) {
        super(id);
        this.nbtType = nbtType;
    }

    public SyncTagType(int nbtType, String name) {
        super(name);
        this.nbtType = nbtType;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        NBTHelper.writeBufBase(buf, this.nbtType, this.current, this.getTagName());
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.current = NBTHelper.readBufBase(buf, this.nbtType, this.getTagName());
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.current != null) {
            NBTHelper.writeNBTBase(nbt, this.nbtType, this.current, this.getTagName());
        }
        return nbt;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.setObject(NBTHelper.readNBTBase(nbt, this.nbtType, this.getTagName()));
        }
    }

    public SyncTagType<T> setDefault(T def) {
        this.current = def;
        return this;
    }

    public T getObject() {
        return this.current;
    }

    public void setObject(T object) {
        if (!this.current.equals(object)) {
            this.current = object;
            this.markChanged();
        }
    }

    public String toString() {
        return this.current.toString();
    }

    public static class INT_ARRAY
    extends SyncTagType<Integer[]> {
        public INT_ARRAY(int id, int size) {
            super(11, id);
            this.current = new Integer[size];
        }

        public INT_ARRAY(String name, int size) {
            super(11, name);
            this.current = new Integer[size];
        }
    }

    public static class COMPOUND
    extends SyncTagType<NBTTagCompound> {
        public COMPOUND(int id) {
            super(10, id);
            this.current = new NBTTagCompound();
        }

        public COMPOUND(String name) {
            super(10, name);
            this.current = new NBTTagCompound();
        }
    }

    public static class STRING
    extends SyncTagType<String> {
        public STRING(int id) {
            super(8, id);
            this.current = "";
        }

        public STRING(String name) {
            super(8, name);
            this.current = "";
        }
    }

    public static class BYTE_ARRAY
    extends SyncTagType<Byte[]> {
        public BYTE_ARRAY(int id, int size) {
            super(7, id);
            this.current = new Byte[size];
        }

        public BYTE_ARRAY(String name, int size) {
            super(7, name);
            this.current = new Byte[size];
        }
    }

    public static class DOUBLE
    extends SyncTagType<Double> {
        public DOUBLE(int id) {
            super(6, id);
            this.current = 0.0;
        }

        public DOUBLE(String name) {
            super(6, name);
            this.current = 0.0;
        }
    }

    public static class FLOAT
    extends SyncTagType<Float> {
        public FLOAT(int id) {
            super(5, id);
            this.current = Float.valueOf(0.0f);
        }

        public FLOAT(String name) {
            super(5, name);
            this.current = Float.valueOf(0.0f);
        }
    }

    public static class LONG
    extends SyncTagType<Long> {
        public LONG(int id) {
            super(4, id);
            this.current = 0L;
        }

        public LONG(String name) {
            super(4, name);
            this.current = 0L;
        }

        public void increaseBy(long i) {
            this.setObject((Long)this.getObject() + i);
            this.markChanged();
        }

        public void decreaseBy(long i) {
            this.setObject((Long)this.getObject() - i);
            this.markChanged();
        }
    }

    public static class INT
    extends SyncTagType<Integer> {
        public INT(int id) {
            super(3, id);
            this.current = 0;
        }

        public INT(String name) {
            super(3, name);
            this.current = 0;
        }

        public void increaseBy(int i) {
            this.setObject((Integer)this.getObject() + i);
            this.markChanged();
        }

        public void decreaseBy(int i) {
            this.setObject((Integer)this.getObject() - i);
            this.markChanged();
        }
    }

    public static class SHORT
    extends SyncTagType<Short> {
        public SHORT(int id) {
            super(2, id);
            this.current = 0;
        }

        public SHORT(String name) {
            super(2, name);
            this.current = 0;
        }

        public void increaseBy(int i) {
            this.setObject((short)((Short)this.getObject() + i));
            this.markChanged();
        }

        public void decreaseBy(int i) {
            this.setObject((short)((Short)this.getObject() - i));
            this.markChanged();
        }
    }

    public static class BYTE
    extends SyncTagType<Byte> {
        public BYTE(int id) {
            super(1, id);
            this.current = 0;
        }

        public BYTE(String name) {
            super(1, name);
            this.current = 0;
        }
    }

    public static class BOOLEAN
    extends SyncTagType<Boolean> {
        public BOOLEAN(int id) {
            super(0, id);
            this.current = false;
        }

        public BOOLEAN(String name) {
            super(0, name);
            this.current = false;
        }

        public void invert() {
            this.setObject((Boolean)this.getObject() == false);
            this.markChanged();
        }
    }
}

