/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import com.google.common.collect.Lists;
import java.util.List;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.ISyncPart;

public abstract class SyncPart
extends DirtyPart
implements ISyncPart {
    public byte id = (byte)-1;
    private String name;
    private List<NBTHelper.SyncType> types = Lists.newArrayList((Object[])new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC});

    public SyncPart(int id) {
        this.id = (byte)id;
    }

    public SyncPart(String name) {
        this.name = name;
    }

    @Override
    public String getTagName() {
        if (this.name == null) {
            return String.valueOf(this.id);
        }
        return this.name;
    }

    @Override
    public boolean canSync(NBTHelper.SyncType syncType) {
        NBTHelper.SyncType[] array = new NBTHelper.SyncType[this.types.size()];
        return syncType.isType(this.types.toArray(array));
    }

    public SyncPart addSyncType(NBTHelper.SyncType ... add) {
        NBTHelper.SyncType[] array = this.types.toArray(new NBTHelper.SyncType[this.types.size()]);
        for (NBTHelper.SyncType type : add) {
            if (type.isType(array)) continue;
            this.types.add(type);
        }
        return this;
    }

    public SyncPart removeSyncType(NBTHelper.SyncType ... remove) {
        NBTHelper.SyncType[] array = this.types.toArray(new NBTHelper.SyncType[this.types.size()]);
        for (NBTHelper.SyncType type : remove) {
            if (!type.isType(array)) continue;
            this.types.remove((Object)type);
        }
        return this;
    }
}

