/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.client.BlockModelsCache;
import sonar.core.client.renderers.SonarCustomStateMapper;
import sonar.core.common.block.properties.IMetaRenderer;
import sonar.core.network.SonarCommon;
import sonar.core.registries.ISonarRegistryBlock;
import sonar.core.registries.ISonarRegistryItem;
import sonar.core.translate.LocalisationManager;

public class SonarClient
extends SonarCommon {
    private IThreadListener clientListener;
    public static final SonarCustomStateMapper mapper = new SonarCustomStateMapper();
    public static final LocalisationManager translator = new LocalisationManager();

    @Override
    public <T extends Block> T registerBlock(String modid, ISonarRegistryBlock<T> block) {
        T theBlock = super.registerBlock(modid, block);
        this.registerBlockRenderer(modid, (Block)block.getValue());
        return theBlock;
    }

    public void registerBlockRenderer(String modid, Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item.func_77614_k()) {
            NonNullList stacks = NonNullList.func_191196_a();
            item.func_150895_a(block.func_149708_J(), stacks);
            for (ItemStack stack : stacks) {
                String variant = "variant=meta" + stack.func_77952_i();
                if (block instanceof IMetaRenderer) {
                    IMetaRenderer meta = (IMetaRenderer)block;
                    variant = "variant=" + meta.getVariant(stack.func_77952_i()).func_176610_l();
                }
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation(modid + ':' + item.func_77658_a().substring(5), variant));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(modid + ':' + item.func_77658_a().substring(5), "inventory"));
        }
    }

    @Override
    public <T extends Item> T registerItem(String modid, ISonarRegistryItem<T> item) {
        T theItem = super.registerItem(modid, item);
        this.registerItemRenderer(modid, (Item)item.getValue());
        return theItem;
    }

    public void registerItemRenderer(String modid, Item item) {
        if (item.func_77614_k()) {
            NonNullList stacks = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), stacks);
            for (ItemStack stack : stacks) {
                String variant = "variant=meta" + stack.func_77952_i();
                if (item instanceof IMetaRenderer) {
                    IMetaRenderer meta = (IMetaRenderer)item;
                    variant = "variant=" + meta.getVariant(stack.func_77952_i()).func_176610_l();
                }
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation(modid + ":items/" + item.func_77658_a().substring(5), variant));
            }
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(modid, item.func_77658_a().substring(5)), "inventory"));
        }
    }

    @Override
    public Object getStateMapper() {
        return mapper;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        SonarCore.logger.info("Registering Renderers");
        SonarCore.logger.info("Registered Renderers");
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager resources = (SimpleReloadableResourceManager)manager;
            resources.func_110542_a((IResourceManagerReloadListener)BlockModelsCache.INSTANCE);
            resources.func_110542_a((IResourceManagerReloadListener)translator);
        }
    }

    @Override
    public void serverClose(FMLServerStoppingEvent event) {
        super.serverClose(event);
        translator.clear();
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public World getDimension(int dimensionID) {
        return FMLCommonHandler.instance().getEffectiveSide().isClient() ? Minecraft.func_71410_x().field_71441_e : super.getDimension(dimensionID);
    }

    @Override
    public IThreadListener getThreadListener(Side side) {
        if (side.isClient()) {
            if (this.clientListener == null) {
                this.clientListener = Minecraft.func_71410_x();
            }
            return this.clientListener;
        }
        return super.getThreadListener(side);
    }
}

