/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import java.util.Optional;
import mcmultipart.api.multipart.IMultipartTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.PacketMultipart;

public abstract class PacketMultipartHandler<T extends PacketMultipart>
implements IMessageHandler<T, IMessage> {
    public final IMessage onMessage(T message, MessageContext ctx) {
        World world;
        EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
        if (player != null && (world = player.func_130014_f_()) != null && world.func_175667_e(((PacketMultipart)message).pos)) {
            if (((PacketMultipart)message).slotID != -1) {
                Optional<IMultipartTile> multipartTile = SonarMultipartHelper.getMultipartTileFromSlotID((IBlockAccess)world, ((PacketMultipart)message).pos, ((PacketMultipart)message).slotID);
                if (multipartTile.isPresent()) {
                    return this.processMessage(message, player, world, multipartTile.get(), ctx);
                }
            } else {
                TileEntity tile = world.func_175625_s(((PacketMultipart)message).pos);
                if (tile instanceof IMultipartTile) {
                    return this.processMessage(message, player, world, (IMultipartTile)tile, ctx);
                }
            }
        }
        return null;
    }

    public abstract IMessage processMessage(T var1, EntityPlayer var2, World var3, IMultipartTile var4, MessageContext var5);
}

