/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mcmultipart.api.multipart.IMultipartTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.integration.SonarLoader;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.PacketFlexibleItemStackChangeGui;
import sonar.core.network.PacketFlexibleMultipartChangeGui;
import sonar.core.network.PacketFlexibleOpenGui;
import sonar.core.utils.Pair;

public class FlexibleGuiHandler {
    public Object lastScreen;
    public Object lastContainer;
    public Pair<Object, IFlexibleGui> lastGui;
    public Map<EntityPlayer, Object> lastContainers = new HashMap<EntityPlayer, Object>();
    public Map<EntityPlayer, Pair<Object, IFlexibleGui>> lastGuis = new HashMap<EntityPlayer, Pair<Object, IFlexibleGui>>();
    public Map<EntityPlayer, Integer> lastID = new HashMap<EntityPlayer, Integer>();
    public static String MULTIPART = "multipart";
    public static String TILEENTITY = "tile";
    public static String ITEM = "item";
    public static String ID = "id";
    public static String SLOT_ID = "uuid";

    public static void openMultipartGui(int id, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileSonarMultipart) {
            TileSonarMultipart multipart = (TileSonarMultipart)tile;
            multipart.sendSyncPacket(player);
            multipart.openFlexibleGui(player, id);
        }
    }

    public Pair<Object, IFlexibleGui> getFlexibleGui(int id, EntityPlayer player, World world, BlockPos pos, NBTTagCompound tag) {
        TileEntity obj = null;
        if (SonarLoader.mcmultipartLoaded && tag.func_74767_n(MULTIPART)) {
            int uuid = tag.func_74762_e(SLOT_ID);
            Optional<IMultipartTile> tile = SonarMultipartHelper.getMultipartTileFromSlotID((IBlockAccess)world, pos, uuid);
            obj = tile.isPresent() ? tile.get() : world.func_175625_s(pos);
        } else if (tag.func_74767_n(TILEENTITY)) {
            obj = world.func_175625_s(pos);
        } else if (tag.func_74767_n(ITEM)) {
            obj = player.func_184614_ca();
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof ItemStack && ((ItemStack)obj).func_77973_b() instanceof IFlexibleGui) {
            return new Pair<TileEntity, Item>(obj, ((ItemStack)obj).func_77973_b());
        }
        if (obj instanceof IFlexibleGui) {
            return new Pair<TileEntity, TileEntity>(obj, obj);
        }
        return null;
    }

    public void openBasicTile(boolean change, TileEntity tile, EntityPlayer player, World world, BlockPos pos, int id) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(TILEENTITY, true);
        this.openGui(change, player, world, pos, id, tag);
    }

    public void openBasicMultipart(boolean change, int slotID, EntityPlayer player, World world, BlockPos pos, int id) {
        if (world.field_72995_K) {
            return;
        }
        if (slotID == -1) {
            this.openBasicTile(change, world.func_175625_s(pos), player, world, pos, id);
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(MULTIPART, true);
        tag.func_74768_a(SLOT_ID, slotID);
        this.openGui(change, player, world, pos, id, tag);
    }

    public void openBasicItemStack(boolean change, ItemStack stack, EntityPlayer player, World world, BlockPos pos, int id) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(ITEM, true);
        this.openGui(change, player, world, pos, id, tag);
    }

    public void openGui(boolean change, EntityPlayer player, World world, BlockPos pos, int id, NBTTagCompound tag) {
        if (player instanceof EntityPlayerMP && !(player instanceof FakePlayer)) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
            Pair<Object, IFlexibleGui> gui = this.getFlexibleGui(id, (EntityPlayer)entityPlayerMP, world, pos, tag);
            ((IFlexibleGui)gui.b).onGuiOpened(gui.a, id, world, (EntityPlayer)entityPlayerMP, tag);
            Container container = (Container)((IFlexibleGui)gui.b).getServerElement(gui.a, id, world, player, tag);
            if (container != null) {
                if (!change) {
                    entityPlayerMP.func_71117_bO();
                    entityPlayerMP.func_71128_l();
                } else {
                    this.lastContainers.put(player, player.field_71070_bA);
                    this.lastGuis.put(player, gui);
                }
                int windowId = entityPlayerMP.field_71139_cq;
                tag.func_74768_a(ID, id);
                SonarCore.network.sendTo((IMessage)new PacketFlexibleOpenGui(change, pos, windowId, tag), (EntityPlayerMP)player);
                entityPlayerMP.field_71070_bA = container;
                entityPlayerMP.field_71070_bA.field_75152_c = windowId;
                entityPlayerMP.field_71070_bA.func_75132_a((IContainerListener)entityPlayerMP);
            }
        }
    }

    public void openGuiClient(EntityPlayer player, BlockPos pos, NBTTagCompound tag, int id, int windowID, boolean change) {
        Pair<Object, IFlexibleGui> gui = SonarCore.instance.guiHandler.getFlexibleGui(id, player, player.func_130014_f_(), pos, tag);
        if (change) {
            FlexibleGuiHandler.setLastContainer(player.field_71070_bA, player, Side.CLIENT);
            FlexibleGuiHandler.setLastGui(gui, player, Side.CLIENT);
            SonarCore.instance.guiHandler.lastScreen = Minecraft.func_71410_x().field_71462_r;
        }
        FMLClientHandler.instance().showGuiScreen(((IFlexibleGui)gui.b).getClientElement(gui.a, id, player.func_130014_f_(), player, tag));
        player.field_71070_bA.field_75152_c = windowID;
    }

    public static void changeGui(IFlexibleGui guiTile, int id, int returnID, World world, EntityPlayer player) {
        if (guiTile instanceof TileSonarMultipart) {
            TileSonarMultipart multipart = (TileSonarMultipart)((Object)guiTile);
            SonarCore.network.sendToServer((IMessage)new PacketFlexibleMultipartChangeGui(multipart.getSlotID(), multipart.getCoords().getBlockPos(), id, returnID));
        }
        if (guiTile instanceof Item) {
            SonarCore.network.sendToServer((IMessage)new PacketFlexibleItemStackChangeGui(player.func_180425_c(), id, returnID));
        }
    }

    public static Object getLastContainer(EntityPlayer player, Side side) {
        return side.isServer() ? SonarCore.instance.guiHandler.lastContainers.get(player) : SonarCore.instance.guiHandler.lastContainer;
    }

    public static Pair<Object, IFlexibleGui> getLastGui(EntityPlayer player, Side side) {
        return side.isServer() ? SonarCore.instance.guiHandler.lastGuis.get(player) : SonarCore.instance.guiHandler.lastGui;
    }

    public static void setLastContainer(Object obj, EntityPlayer player, Side side) {
        if (side.isServer()) {
            SonarCore.instance.guiHandler.lastContainers.put(player, obj);
        } else {
            SonarCore.instance.guiHandler.lastContainer = obj;
        }
    }

    public static void setLastGui(Pair<Object, IFlexibleGui> obj, EntityPlayer player, Side side) {
        if (side.isServer()) {
            SonarCore.instance.guiHandler.lastGuis.put(player, obj);
        } else {
            SonarCore.instance.guiHandler.lastGui = obj;
        }
    }

    public static boolean closeGui(EntityPlayer player, Side side) {
        Object container = FlexibleGuiHandler.getLastContainer(player, side);
        if (container != null) {
            if (side == Side.CLIENT) {
                player.field_71070_bA = (Container)container;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)SonarCore.instance.guiHandler.lastScreen);
                SonarCore.instance.guiHandler.lastScreen = null;
                SonarCore.instance.guiHandler.lastContainer = null;
            } else {
                player.field_71070_bA.func_75134_a(player);
                Pair<Object, IFlexibleGui> gui = FlexibleGuiHandler.getLastGui(player, side);
                ((IFlexibleGui)gui.b).onGuiOpened(gui.a, SonarCore.instance.guiHandler.lastID.get(player), player.func_130014_f_(), player, new NBTTagCompound());
                player.field_71070_bA = (Container)container;
                SonarCore.instance.guiHandler.lastContainers.remove(player);
            }
            return true;
        }
        return false;
    }
}

