/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.inventory;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.ISyncPart;

public class SonarLargeInventory
extends DirtyPart
implements IItemHandler,
INBTSyncable,
ISyncPart {
    public StoredItemStack[] slots;
    public int limit = 64;
    public int numStacks = 4;
    public int size;

    public SonarLargeInventory(int size, int numStacks) {
        this.size = size;
        this.slots = new StoredItemStack[size];
        this.numStacks = numStacks;
    }

    public SonarLargeInventory setStackLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b(this.getTagName())) {
            NBTTagList list = nbt.func_150295_c(this.getTagName(), 10);
            StoredItemStack[] stacks = new StoredItemStack[this.size];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                byte b = compound.func_74771_c("Slot");
                if (b < 0 || b >= this.size) continue;
                stacks[b] = NBTHelper.instanceNBTSyncable(StoredItemStack.class, compound);
            }
            this.slots = stacks;
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.size; ++i) {
                StoredItemStack stack = this.slots[i];
                if (stack == null || stack.getStackSize() == 0L) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74774_a("Slot", (byte)i);
                list.func_74742_a((NBTBase)stack.writeData(compound, type));
            }
            nbt.func_74782_a(this.getTagName(), (NBTBase)list);
        }
        return nbt;
    }

    public ItemStack getStackInSlot(int slot) {
        StoredItemStack largeStack = this.getLargeStack(slot);
        if (largeStack != null) {
            ItemStack stack = largeStack.getItemStack().func_77946_l();
            stack.func_190920_e((int)largeStack.getStackSize());
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlots() {
        return this.size;
    }

    public long getCount(int slot) {
        StoredItemStack largeStack = this.getLargeStack(slot);
        return largeStack == null ? 0L : largeStack.getStackSize();
    }

    public StoredItemStack getLargeStack(int slot) {
        if (this.size > slot) {
            return this.slots[slot];
        }
        return null;
    }

    public void setLargeStack(int slot, StoredItemStack stack) {
        this.slots[slot] = stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int maxAdd;
        StoredItemStack stored;
        if (!stack.func_190926_b() && this.isItemValidForSlot(slot, stack) && ((stored = this.slots[slot]) == null || stored.getStackSize() == 0L || stored.equalStack(stack) && stored.getStackSize() < (long)(this.numStacks * stack.func_77976_d())) && (maxAdd = (int)Math.min((long)(this.numStacks * stack.func_77976_d()) - (stored != null ? stored.getStackSize() : 0L), (long)stack.func_190916_E())) != 0) {
            if (!simulate) {
                if (stored != null && stored.getStackSize() != 0L) {
                    stored.stored += (long)maxAdd;
                } else {
                    stored = this.slots[slot] = new StoredItemStack(stack.func_77946_l(), maxAdd);
                }
            }
            return maxAdd == stack.func_190916_E() ? ItemStack.field_190927_a : new StoredItemStack(stack.func_77946_l()).setStackSize(stack.func_190916_E() - maxAdd).getActualStack();
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        StoredItemStack largeStack = this.slots[slot];
        if (largeStack != null && largeStack.getStackSize() > 0L) {
            int toRemove = (int)Math.min((long)amount, largeStack.getStackSize());
            if (toRemove == 0) {
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                largeStack.stored -= (long)toRemove;
            }
            return largeStack.copy().setStackSize(toRemove).getActualStack();
        }
        return ItemStack.field_190927_a;
    }

    public boolean isItemValidForSlot(int slot, ItemStack item) {
        return true;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync == NBTHelper.SyncType.SAVE;
    }

    @Override
    public String getTagName() {
        return "Items";
    }

    public void markDirty() {
        this.markChanged();
    }

    public int getSlotLimit(int slot) {
        return this.limit;
    }
}

