/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.inventory.ContainerSync;
import sonar.core.inventory.ILargeInventory;
import sonar.core.inventory.slots.SlotLarge;

public abstract class ContainerLargeInventory
extends ContainerSync {
    ILargeInventory entity;

    public ContainerLargeInventory(TileEntitySonar tile) {
        super(tile);
        this.entity = (ILargeInventory)((Object)tile);
    }

    protected boolean mergeSpecial(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!reverseDirection && i < endIndex || reverseDirection && i >= startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                StoredItemStack stored = this.entity.getTileInv().getLargeStack(i);
                if (!(itemstack.func_190926_b() || itemstack.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77960_j() != itemstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack))) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = stack.func_77976_d())) {
                        stack.func_190920_e(0);
                        if (slot instanceof SlotLarge) {
                            this.entity.getTileInv().setLargeStack(i, stored.setStackSize(j));
                        } else {
                            itemstack.func_190920_e(j);
                        }
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(-maxSize - itemstack.func_190916_E());
                        if (slot instanceof SlotLarge) {
                            stored.add(new StoredItemStack(itemstack.func_77946_l()).setStackSize(maxSize));
                            this.entity.getTileInv().setLargeStack(i, stored);
                        } else {
                            itemstack.func_190920_e(maxSize);
                        }
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (stack.func_190916_E() > 0) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!reverseDirection && i < endIndex || reverseDirection && i >= startIndex) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (slot1.func_75214_a(stack)) {
                    if (slot1 instanceof SlotLarge) {
                        StoredItemStack target = this.entity.getTileInv().getLargeStack(i);
                        if (target != null) {
                            target = target.copy();
                            itemstack1 = target.getFullStack();
                        } else {
                            target = new StoredItemStack(stack).setStackSize(0L);
                            itemstack1 = ItemStack.field_190927_a;
                        }
                        int max = target.getItemStack().func_77976_d() * this.entity.getTileInv().numStacks;
                        if (target.stored < (long)max) {
                            int toAdd = (int)Math.min((long)max - target.stored, (long)stack.func_190916_E());
                            target.add(new StoredItemStack(stack.func_77946_l()).setStackSize(toAdd));
                            this.entity.getTileInv().setLargeStack(i, target);
                            stack.func_190918_g(toAdd);
                            if (stack.func_190916_E() == 0) {
                                flag = true;
                                break;
                            }
                        }
                    } else if (itemstack1.func_190926_b()) {
                        slot1.func_75215_d(stack.func_77946_l());
                        slot1.func_75218_e();
                        stack.func_190920_e(0);
                        flag = true;
                        break;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ItemStack func_184996_a(int slotID, int dragType, ClickType button, EntityPlayer player) {
        if (slotID >= this.entity.getTileInv().size || button == ClickType.QUICK_MOVE) {
            return super.func_184996_a(slotID, dragType, button, player);
        }
        if (slotID >= 0) {
            StoredItemStack clicked = this.entity.getTileInv().getLargeStack(slotID);
            if ((dragType == 0 || dragType == 1) && button == ClickType.PICKUP) {
                ItemStack held = player.field_71071_by.func_70445_o();
                if (held.func_190926_b() && clicked != null && clicked.getItemStack() != null) {
                    int toRemove = (int)Math.min((long)clicked.getItemStack().func_77976_d(), clicked.stored);
                    if (dragType == 1 && toRemove != 1) {
                        toRemove = (int)Math.ceil(toRemove / 2);
                    }
                    if (toRemove != 0) {
                        StoredItemStack newStack = clicked.copy();
                        ItemStack stack = newStack.copy().setStackSize(toRemove).getFullStack();
                        newStack.remove(stack);
                        if (newStack.stored == 0L) {
                            this.entity.getTileInv().setLargeStack(slotID, null);
                        }
                        player.field_71071_by.func_70437_b(stack);
                        this.entity.getTileInv().setLargeStack(slotID, newStack);
                        return ItemStack.field_190927_a;
                    }
                } else if (!held.func_190926_b()) {
                    int maxAdd;
                    if (clicked == null || clicked.getItemStack().func_190926_b() || clicked.getStackSize() == 0L) {
                        if (this.entity.getTileInv().isItemValidForSlot(slotID * this.entity.getTileInv().numStacks, held)) {
                            this.entity.getTileInv().setLargeStack(slotID, new StoredItemStack(held));
                            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                            return ItemStack.field_190927_a;
                        }
                    } else if (clicked != null && !clicked.getItemStack().func_190926_b() && clicked.equalStack(held) && (maxAdd = (int)Math.min((long)(held.func_77976_d() * this.entity.getTileInv().numStacks) - clicked.getStackSize(), (long)held.func_190916_E())) > 0) {
                        StoredItemStack newStack = clicked.copy();
                        newStack.add(new StoredItemStack(held).setStackSize(maxAdd));
                        held.func_190918_g(maxAdd);
                        this.entity.getTileInv().setLargeStack(slotID, newStack);
                        return ItemStack.field_190927_a;
                    }
                }
            }
        }
        return ItemStack.field_190927_a;
    }
}

