/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.inventory;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import sonar.core.api.SonarAPI;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.InventoryHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.inventory.ISonarInventory;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.ISyncPart;

public abstract class AbstractSonarInventory<T extends AbstractSonarInventory>
extends DirtyPart
implements ISonarInventory,
ISyncPart {
    public final SubItemHandler sub_handler;
    public NonNullList<ItemStack> slots;
    public int size;
    public int limit = 64;
    public EnumFacing face;

    public AbstractSonarInventory(int size) {
        this.size = size;
        this.slots = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.sub_handler = new SubItemHandler(this);
    }

    @Override
    public List<ItemStack> slots() {
        return this.slots;
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing side) {
        this.face = side;
        return this.sub_handler;
    }

    public T setStackLimit(int limit) {
        this.limit = limit;
        return (T)this;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.canSync(type)) {
            this.slots = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.slots);
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.canSync(type)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.slots);
        }
        return nbt;
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.slots.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack split = ItemStackHelper.func_188382_a(this.slots, (int)index, (int)count);
        if (!ItemStack.func_179545_c((ItemStack)split, (ItemStack)((ItemStack)this.slots.get(index)))) {
            this.func_70296_d();
        }
        return split;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack remove = ItemStackHelper.func_188383_a(this.slots, (int)index);
        if (!ItemStack.func_179545_c((ItemStack)remove, (ItemStack)((ItemStack)this.slots.get(index)))) {
            this.func_70296_d();
        }
        return remove;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.slots.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.limit;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(this.getSyncTypes());
    }

    public NBTHelper.SyncType[] getSyncTypes() {
        return new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE};
    }

    @Override
    public String getTagName() {
        return "Items";
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        StoredItemStack add = new StoredItemStack(stack);
        boolean bool = InventoryHelper.addStack(this, add, slot, this.func_70297_j_(), ActionType.getTypeForAction(simulate));
        return bool ? add.getActualStack() : ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stored = this.func_70301_a(slot);
        if (stored.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        StoredItemStack remove = new StoredItemStack(stored, amount);
        boolean bool = InventoryHelper.removeStack(this, remove, stored, slot, ActionType.getTypeForAction(simulate));
        remove = SonarAPI.getItemHelper().getStackToAdd(amount, new StoredItemStack(stored), remove);
        return remove.getActualStack();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.slots) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public static class SubItemHandler
    implements IItemHandler {
        public AbstractSonarInventory inv;

        public SubItemHandler(AbstractSonarInventory inv) {
            this.inv = inv;
        }

        public int getSlots() {
            return this.inv.func_70302_i_();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inv.func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.inv.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inv.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.inv.func_70297_j_();
        }
    }
}

