/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.planting.vanilla;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import sonar.core.common.item.SonarSeeds;
import sonar.core.integration.planting.IPlanter;

public class Planter
implements IPlanter {
    @Override
    public boolean isLoadable() {
        return true;
    }

    @Override
    public String getName() {
        return "Vanilla Planter";
    }

    @Override
    public boolean canTierPlant(ItemStack stack, int tier) {
        if (stack.func_77973_b() instanceof SonarSeeds) {
            return ((SonarSeeds)stack.func_77973_b()).canTierUse(tier);
        }
        return stack.func_77973_b() instanceof IPlantable;
    }

    @Override
    public EnumPlantType getPlantType(ItemStack stack, World world, BlockPos pos) {
        IPlantable plant = (IPlantable)stack.func_77973_b();
        return plant.getPlantType((IBlockAccess)world, pos);
    }

    @Override
    public IBlockState getPlant(ItemStack stack, World world, BlockPos pos) {
        IPlantable plant = (IPlantable)stack.func_77973_b();
        BlockPos blockPos = pos.func_177972_a(EnumFacing.DOWN);
        IBlockState state = world.func_180495_p(blockPos);
        Block base = state.func_177230_c();
        if (base != null && !base.isAir(state, (IBlockAccess)world, blockPos) && base.canSustainPlant(state, (IBlockAccess)world, blockPos, EnumFacing.UP, plant)) {
            return plant.getPlant((IBlockAccess)world, pos);
        }
        return null;
    }
}

