/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.multipart;

import java.util.Optional;
import javax.annotation.Nullable;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.ref.MCMPCapabilities;
import mcmultipart.slot.SlotRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.PacketRequestMultipartSync;

public class TileSonarMultipart
extends TileEntitySonar
implements IMultipartTile,
ITickable {
    public IPartInfo info;

    public Optional<IPartInfo> getInfo() {
        return Optional.ofNullable(this.info);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.loaded = true;
    }

    public void setPartInfo(IPartInfo info) {
        this.info = info;
    }

    public int getSlotID() {
        return this.info == null ? -1 : SlotRegistry.INSTANCE.getSlotID(this.info.getSlot());
    }

    @Override
    public void markBlockForUpdate() {
        if (this.isServer()) {
            this.func_70296_d();
            SonarMultipartHelper.sendMultipartSyncAround(this, 128);
        } else {
            this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
            this.func_145831_w().func_175726_f(this.func_174877_v()).func_177427_f(true);
        }
    }

    @Override
    public IMessage createSyncPacket(NBTTagCompound tag, NBTHelper.SyncType type) {
        return SonarMultipartHelper.buildSyncPacket(this, tag, type);
    }

    @Override
    public void requestSyncPacket() {
        int slotID = this.getSlotID();
        if (slotID == -1) {
            super.requestSyncPacket();
        } else {
            SonarCore.network.sendToServer((IMessage)new PacketRequestMultipartSync(this.func_174877_v(), slotID));
        }
    }

    public void sendSyncPacket() {
        if (!this.func_145831_w().field_72995_K) {
            SonarMultipartHelper.sendMultipartSyncAround(this, 64);
        } else {
            SonarMultipartHelper.sendMultipartSyncToServer(this);
        }
    }

    public void sendByteBufPacket(int id) {
        if (!this.func_145831_w().field_72995_K) {
            SonarMultipartHelper.sendMultipartPacketAround(this, id, 64);
        } else {
            SonarMultipartHelper.sendMultipartPacketToServer(this, id);
        }
    }

    public final void openGui(EntityPlayer player, Object mod) {
        player.openGui(mod, this.getSlotID(), this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
    }

    public final void openFlexibleGui(EntityPlayer player, int id) {
        SonarCore.instance.guiHandler.openBasicMultipart(false, this.getSlotID(), player, this.func_145831_w(), this.func_174877_v(), id);
    }

    public final void changeFlexibleGui(EntityPlayer player, int id) {
        SonarCore.instance.guiHandler.openBasicMultipart(true, this.getSlotID(), player, this.func_145831_w(), this.func_174877_v(), id);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == MCMPCapabilities.MULTIPART_TILE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == MCMPCapabilities.MULTIPART_TILE) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }
}

