/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.jei;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import sonar.core.integration.jei.ISonarJEIRecipeBuilder;
import sonar.core.integration.jei.JEIRecipeV2;
import sonar.core.recipes.IRecipeHelperV2;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.recipes.RecipeObjectType;

public class JEIHelper {
    public static List<ISonarJEIRecipeBuilder> recipeBuilders = new ArrayList<ISonarJEIRecipeBuilder>();

    public static void registerRecipeBuilder(ISonarJEIRecipeBuilder builder) {
        recipeBuilders.add(builder);
    }

    public static ArrayList<JEIRecipeV2> getJEIRecipes(IRecipeHelperV2 recipeHelper, Class<? extends JEIRecipeV2> recipeClass) {
        ArrayList<JEIRecipeV2> recipesV2 = new ArrayList<JEIRecipeV2>();
        if (recipeHelper != null && recipeHelper instanceof RecipeHelperV2) {
            RecipeHelperV2 helper = (RecipeHelperV2)recipeHelper;
            for (ISonarRecipe recipe : helper.getRecipes()) {
                try {
                    recipesV2.add(recipeClass.getConstructor(RecipeHelperV2.class, ISonarRecipe.class).newInstance(helper, recipe));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return recipesV2;
    }

    public static class RecipeMapping {
        public int slotPos;
        public int xPos;
        public int yPos;

        public RecipeMapping(int slotPos, int xPos, int yPos) {
            this.slotPos = slotPos;
            this.xPos = xPos;
            this.yPos = yPos;
        }
    }

    public static class RecipeMapper {
        public Map<RecipeObjectType, Map<Integer, RecipeMapping>> map = new HashMap<RecipeObjectType, Map<Integer, RecipeMapping>>();

        public void map(RecipeObjectType type, int recipePos, int slotPos, int xPos, int yPos) {
            this.map(type, recipePos, new RecipeMapping(slotPos, xPos, yPos));
        }

        public void map(RecipeObjectType type, int recipePos, RecipeMapping mapping) {
            this.map.computeIfAbsent(type, k -> new HashMap());
            this.map.get((Object)type).put(recipePos, mapping);
        }

        public void mapTo(IGuiItemStackGroup stacks, IIngredients ingredients) {
            for (Map.Entry<RecipeObjectType, Map<Integer, RecipeMapping>> entry : this.map.entrySet()) {
                List objects = entry.getKey() == RecipeObjectType.INPUT ? ingredients.getInputs(ItemStack.class) : ingredients.getOutputs(ItemStack.class);
                for (Map.Entry<Integer, RecipeMapping> mapping : entry.getValue().entrySet()) {
                    RecipeMapping recipe = mapping.getValue();
                    stacks.init(recipe.slotPos, entry.getKey() == RecipeObjectType.INPUT, recipe.xPos, recipe.yPos);
                    Object obj = objects.get(mapping.getKey());
                    if (obj != null) {
                        stacks.set(recipe.slotPos, (List)obj);
                        continue;
                    }
                    stacks.set(recipe.slotPos, (ItemStack)obj);
                }
            }
        }
    }
}

