/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import sonar.core.helpers.ListHelper;

public class SonarTextFormatter {
    public static final String START_SELECTION_CHAR = "\uffef";
    public static final String END_SELECTION_CHAR = "\ufff0";
    private static final String CODE_STRING = "\u00a7";
    private static final Pattern START_SELECTION = Pattern.compile("(?i)\uffef");
    private static final Pattern END_SELECTION = Pattern.compile("(?i)\ufff0");
    private static final Pattern ALL_FORMATS = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static final Pattern SPECIAL_FORMATS = Pattern.compile("(?i)\u00a7[K-O]");
    private static final Pattern COLOUR_FORMATS = Pattern.compile("(?i)\u00a7[0-9A-F]");
    private static final Pattern RESET = Pattern.compile("(?i)\u00a7[R]");

    public static String enableSpecialFormattingForSelections(String s, List<TextFormatting> formatting) {
        return SonarTextFormatter.formatSelections(s, f -> SonarTextFormatter.enableSpecialFormattingForString(f, formatting));
    }

    public static String enableSpecialFormattingForString(String s, List<TextFormatting> formatting) {
        s = SonarTextFormatter.removeSelectedFormatting(s, formatting);
        s = SonarTextFormatter.removeAllOldResets(s);
        String formatString = SonarTextFormatter.createFormattingString(formatting);
        s = s.replaceAll(TextFormatting.RESET.toString(), TextFormatting.RESET + formatString);
        s = formatString + s;
        s = SonarTextFormatter.checkClosingResets(s);
        return s;
    }

    public static String disableSpecialFormattingForSelections(String s, List<TextFormatting> formatting) {
        return SonarTextFormatter.formatSelections(s, f -> SonarTextFormatter.disableSpecialFormattingForString(f, formatting));
    }

    public static String disableSpecialFormattingForString(String s, List<TextFormatting> formatting) {
        s = SonarTextFormatter.removeSelectedFormatting(s, formatting);
        s = SonarTextFormatter.removeAllOldResets(s);
        s = SonarTextFormatter.checkClosingResets(s);
        return s;
    }

    public static String setTextColourForSelections(String s, TextFormatting colour) {
        return SonarTextFormatter.formatSelections(s, f -> SonarTextFormatter.setTextColourForString(f, colour));
    }

    public static String setTextColourForString(String s, TextFormatting colour) {
        s = SonarTextFormatter.removeAllColourFormatting(s);
        s = SonarTextFormatter.removeAllOldResets(s);
        if (colour != null) {
            s = s.replaceAll(TextFormatting.RESET.toString(), TextFormatting.RESET.toString() + colour.toString());
        }
        s = SonarTextFormatter.checkClosingResets(s);
        return s;
    }

    public static String formatSelections(String s, Function<String, String> format) {
        return SonarTextFormatter.formatBetweenPlaceHolders(s, START_SELECTION_CHAR, END_SELECTION_CHAR, format);
    }

    public static String formatBetweenPlaceHolders(String str, String open, String close, Function<String, String> format) {
        if ((str = SonarTextFormatter.removeAllOldResets(str)) == null || StringUtils.isEmpty((CharSequence)open) || StringUtils.isEmpty((CharSequence)close)) {
            return str;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return str;
        }
        int closeLen = close.length();
        int openLen = open.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < strLen) {
            if (pos >= strLen + closeLen) {
                list.add(str.substring(pos, strLen));
                break;
            }
            int start = str.indexOf(open, pos);
            if (start < 0) {
                list.add(str.substring(pos, strLen));
                break;
            }
            int end = str.indexOf(close, start += openLen);
            if (end < 0) {
                list.add(str.substring(pos, strLen));
                break;
            }
            list.add(str.substring(pos, start));
            list.add(format.apply(str.substring(start, end)));
            list.add(close);
            pos = end + closeLen;
        }
        if (list.isEmpty()) {
            return str;
        }
        StringBuilder build = new StringBuilder();
        list.forEach(s -> build.append((String)s));
        return build.toString();
    }

    public static String removeAllSelections(String s) {
        String r_start = s.replaceAll(START_SELECTION_CHAR, "");
        String r_end = r_start.replaceAll(END_SELECTION_CHAR, "");
        return r_end;
    }

    public static String removeAllFormatting(String s) {
        return ALL_FORMATS.matcher(s).replaceAll("");
    }

    public static String removeAllSpecialFormatting(String s) {
        return SPECIAL_FORMATS.matcher(s).replaceAll("");
    }

    public static String removeAllColourFormatting(String s) {
        return COLOUR_FORMATS.matcher(s).replaceAll("");
    }

    public static String removeSelectedFormatting(String s, List<TextFormatting> format) {
        return SonarTextFormatter.createFormattingPattern(format).matcher(s).replaceAll("");
    }

    public static String checkClosingResets(String s) {
        return SonarTextFormatter.checkFirstReset(SonarTextFormatter.checkFinalReset(s));
    }

    public static String removeClosingResets(String s) {
        return SonarTextFormatter.removeFirstReset(SonarTextFormatter.removeFinalReset(s));
    }

    public static String checkFinalReset(String s) {
        if (!s.endsWith(TextFormatting.RESET.toString())) {
            return s + TextFormatting.RESET.toString();
        }
        return s;
    }

    public static String checkFirstReset(String s) {
        if (!s.startsWith(TextFormatting.RESET.toString())) {
            return TextFormatting.RESET.toString() + s;
        }
        return s;
    }

    public static String removeFinalReset(String s) {
        if (s.endsWith(TextFormatting.RESET.toString())) {
            return s.substring(0, s.length() - TextFormatting.RESET.toString().length());
        }
        return s;
    }

    public static String removeFirstReset(String s) {
        if (s.startsWith(TextFormatting.RESET.toString())) {
            return s.replaceFirst(TextFormatting.RESET.toString(), "");
        }
        return s;
    }

    public static String removeAllOldResets(String s) {
        String[] resetStrings;
        String newS = "";
        for (String subS : resetStrings = RESET.split(s)) {
            newS = newS + subS;
            if (subS.indexOf(CODE_STRING) == -1) continue;
            newS = newS + TextFormatting.RESET.toString();
        }
        return newS;
    }

    public static Pattern createFormattingPattern(List<TextFormatting> format) {
        String s = "";
        for (TextFormatting text : format) {
            String format_code = text.toString().replace(CODE_STRING, "");
            if (s.contains(format_code)) continue;
            s = s + format_code;
        }
        return Pattern.compile("(?i)\u00a7[" + s + "]");
    }

    public static String createFormattingString(List<TextFormatting> format) {
        String s = "";
        for (TextFormatting text : format) {
            String format_code = text.toString();
            if (s.contains(format_code)) continue;
            s = s + format_code;
        }
        return s;
    }

    public static List<TextFormatting> readFormattingFromNBT(NBTTagCompound nbt) {
        int[] ordinals;
        ArrayList formatting = Lists.newArrayList();
        for (int i : ordinals = nbt.func_74759_k("tf")) {
            formatting.add(TextFormatting.values()[i]);
        }
        return formatting;
    }

    public static NBTTagCompound writeFormattingToNBT(NBTTagCompound nbt, List<TextFormatting> format) {
        int[] ordinals = ListHelper.getOrdinals((Enum[])((TextFormatting[])format.toArray()));
        if (ordinals.length > 0) {
            nbt.func_74783_a("tf", ordinals);
        }
        return nbt;
    }
}

