/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sonar.core.SonarCore;
import sonar.core.api.IRegistryObject;

public abstract class RegistryHelper<T extends IRegistryObject> {
    private List<T> objects = new ArrayList<T>();
    private Map<String, Integer> objectIDs = new THashMap();
    private Map<Integer, String> objectNames = new THashMap();

    public abstract void register();

    public abstract String registeryType();

    public void removeAll() {
        this.objects.clear();
    }

    public List<T> getObjects() {
        return this.objects;
    }

    public T getRegisteredObject(int objectID) {
        String helperName = this.objectNames.get(objectID);
        if (helperName == null || helperName.isEmpty()) {
            return this.getDefault();
        }
        for (IRegistryObject provider : this.objects) {
            if (!provider.getName().equals(helperName)) continue;
            return (T)provider;
        }
        return this.getDefault();
    }

    public T getRegisteredObject(String name) {
        if (name == null || name.isEmpty()) {
            return this.getDefault();
        }
        for (IRegistryObject provider : this.objects) {
            if (!provider.getName().equals(name)) continue;
            return (T)provider;
        }
        return this.getDefault();
    }

    public void registerObject(T object) {
        try {
            if (!object.isLoadable()) {
                SonarCore.logger.warn(this.registeryType() + " wasn't loadable: " + object.getName());
                return;
            }
            if (object != null) {
                if (this.getRegisteredObject(object.getName()) == null) {
                    this.objects.add(object);
                    int id = this.objectIDs.size();
                    this.objectIDs.put(object.getName(), id);
                    this.objectNames.put(id, object.getName());
                    SonarCore.logger.info("Loaded " + this.registeryType() + ": " + object.getName());
                } else {
                    SonarCore.logger.warn(this.registeryType() + " DUPLICATE ID - skipping " + object.getName());
                }
            }
        }
        catch (Exception exception) {
            SonarCore.logger.warn(this.registeryType() + " : Exception Loading Helper: " + exception.getMessage());
        }
    }

    public int getObjectID(String name) {
        Integer id = this.objectIDs.get(name);
        return id != null ? id : -1;
    }

    public T getDefault() {
        return null;
    }
}

