/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.util.LinkedHashMap;
import sonar.core.SonarCore;

public abstract class LinkedRegistryHelper<S, P> {
    private LinkedHashMap<S, P> objects = new LinkedHashMap();
    private LinkedHashMap<P, S> objectsReversed = new LinkedHashMap();

    public abstract void register();

    public abstract String registeryType();

    public void removeAll() {
        this.objects.clear();
    }

    public LinkedHashMap<S, P> getMap() {
        return this.objects;
    }

    public LinkedHashMap<P, S> getMapReversed() {
        return this.objectsReversed;
    }

    public P getPrimaryObject(S object) {
        P toReturn = this.objects.get(object);
        if (toReturn == null) {
            return this.getPrimaryDefault();
        }
        return toReturn;
    }

    public S getSecondaryObject(P object) {
        S toReturn = this.objectsReversed.get(object);
        if (toReturn == null) {
            return this.getSecondaryDefault();
        }
        return toReturn;
    }

    public void registerMap(S secondary, P primary) {
        try {
            if (primary != null && secondary != null) {
                this.objects.put(secondary, primary);
                this.objectsReversed.put(primary, secondary);
                SonarCore.logger.info("Loaded " + this.registeryType() + ": " + this.primaryToString(primary) + " = " + this.secondaryToString(secondary));
            } else {
                SonarCore.logger.warn(this.registeryType() + " wasn't loadable: " + this.primaryToString(primary) + " = " + this.secondaryToString(secondary));
            }
        }
        catch (Exception exception) {
            SonarCore.logger.warn(this.registeryType() + " : Exception Loading Helper: " + exception.getMessage());
        }
    }

    public P getPrimaryDefault() {
        return null;
    }

    public S getSecondaryDefault() {
        return null;
    }

    public String primaryToString(P primary) {
        return primary.toString();
    }

    public String secondaryToString(S secondary) {
        return secondary.toString();
    }
}

